/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.coxph;

import hex.genmodel.MojoModel;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class CoxPHMojoModel
extends MojoModel {
    double[] _coef;
    HashMap<Strata, Integer> _strata;
    int _strata_len;
    double[][] _x_mean_cat;
    double[][] _x_mean_num;
    int[] _cat_offsets;
    int _cats;
    double[] _lpBase;
    boolean _useAllFactorLevels;
    int _nums;
    int[] _interactions_1;
    int[] _interactions_2;
    int[] _interaction_targets;
    boolean[] _is_enum_1;
    HashSet<Integer> _interaction_column_index;
    HashMap<Integer, List<String>> _interaction_column_domains;
    InteractionTypes[] _interaction_types;
    int[] _num_offsets;

    CoxPHMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    public double[] score0(double[] row, double[] predictions) {
        return this.score0(row, 0.0, predictions);
    }

    @Override
    public double[] score0(double[] row, double offset, double[] predictions) {
        int[] enumOffset = null;
        if (this._nums == -1) {
            predictions[0] = this.forCategories(row) + this.forOtherColumns(row) - this.forStrata(row) + offset;
        } else {
            if (this._interaction_targets != null) {
                enumOffset = this.evaluateInteractions(row);
            }
            predictions[0] = this.forCategories(row) + this.forOtherColumns(row, enumOffset) - this.forStrata(row) + offset;
        }
        return predictions;
    }

    private double forOtherColumns(double[] row) {
        double result = 0.0;
        int catOffsetDiff = this._cat_offsets[this._cats] - this._cats;
        int i = this._cats;
        while (i + catOffsetDiff < this._coef.length) {
            result += this._coef[catOffsetDiff + i] * this.featureValue(row, i);
            ++i;
        }
        return result;
    }

    private double forOtherColumns(double[] row, int[] enumOffset) {
        double result = 0.0;
        int coefLen = this._coef.length;
        for (int i = 0; i < this._nums; ++i) {
            if (enumOffset == null || enumOffset[i] < 0) {
                if (this._num_offsets[i] >= coefLen) break;
                result += this._coef[this._num_offsets[i]] * this.featureValue(row, i + this._cats);
                continue;
            }
            if (enumOffset[i] >= coefLen) break;
            result += this._coef[enumOffset[i]] * this.featureValue(row, i + this._cats);
        }
        return result;
    }

    private double forStrata(double[] row) {
        int strata = this.strataForRow(row);
        return this._lpBase[strata];
    }

    private double forCategories(double[] row) {
        double result = 0.0;
        if (!this._useAllFactorLevels) {
            for (int category = 0; category < this._cats; ++category) {
                double val = this.featureValue(row, category);
                if (Double.isNaN(val)) {
                    result = Double.NaN;
                    continue;
                }
                if (!(val >= 0.0)) continue;
                if (this._interaction_column_index.contains(category)) {
                    result += this.forOneCategory(row, category, 0);
                    continue;
                }
                result += this.forOneCategory(row, category, 1);
            }
        } else {
            for (int category = 0; category < this._cat_offsets.length - 1; ++category) {
                result += this.forOneCategory(row, category, 0);
            }
        }
        return result;
    }

    double forOneCategory(double[] row, int category, int lowestFactorValue) {
        int value = (int)this.featureValue(row, category) - lowestFactorValue;
        if ((double)value != this.featureValue(row, category) - (double)lowestFactorValue) {
            throw new IllegalArgumentException("categorical value out of range");
        }
        int x = value + this._cat_offsets[category];
        if (value >= 0 && x < this._cat_offsets[category + 1]) {
            return this._coef[x];
        }
        return 0.0;
    }

    double[] computeLpBase() {
        int _numStart = this._x_mean_cat.length >= 1 ? this._x_mean_cat[0].length : 0;
        int size = 0 < this._strata.size() ? this._strata.size() : 1;
        double[] lpBase = new double[size];
        for (int s = 0; s < size; ++s) {
            int i;
            for (i = 0; i < this._x_mean_cat[s].length; ++i) {
                int n = s;
                lpBase[n] = lpBase[n] + this._x_mean_cat[s][i] * this._coef[i];
            }
            for (i = 0; i < this._x_mean_num[s].length; ++i) {
                int n = s;
                lpBase[n] = lpBase[n] + this._x_mean_num[s][i] * this._coef[i + _numStart];
            }
        }
        return lpBase;
    }

    double featureValue(double[] row, int featureIdx) {
        return row[featureIdx + this._strata_len];
    }

    private int strataForRow(double[] row) {
        if (0 == this._strata.size()) {
            return 0;
        }
        Strata o = new Strata(row, this._strata_len);
        return this._strata.get(o);
    }

    private int[] evaluateInteractions(double[] row) {
        int[] enumOffset = new int[this._nums];
        Arrays.fill(enumOffset, -1);
        for (int interactionIndex = 0; interactionIndex < this._interaction_targets.length; ++interactionIndex) {
            int target = this._interaction_targets[interactionIndex];
            if (!Double.isNaN(row[target])) continue;
            if (InteractionTypes.ENUM_TO_ENUM.equals((Object)this._interaction_types[interactionIndex])) {
                row[target] = this.enumEnumInteractions(row, interactionIndex);
                continue;
            }
            if (InteractionTypes.NUM_TO_NUM.equals((Object)this._interaction_types[interactionIndex])) {
                row[target] = row[this._interactions_1[interactionIndex]] * row[this._interactions_2[interactionIndex]];
                continue;
            }
            this.enumNumInteractions(row, enumOffset, interactionIndex, target);
        }
        return enumOffset;
    }

    private void enumNumInteractions(double[] row, int[] enumOffset, int interactionIndex, int rowIndex) {
        int enumPredIndex = this._is_enum_1[interactionIndex] ? this._interactions_1[interactionIndex] : this._interactions_2[interactionIndex];
        int numPredIndex = this._is_enum_1[interactionIndex] ? this._interactions_2[interactionIndex] : this._interactions_1[interactionIndex];
        int offset = this._num_offsets[rowIndex - this._cats];
        int catLevel = (int)row[enumPredIndex] - (this._useAllFactorLevels ? 0 : 1);
        row[rowIndex] = catLevel < 0 ? 0.0 : row[numPredIndex];
        enumOffset[rowIndex - this._cats] = catLevel + offset;
    }

    private int enumEnumInteractions(double[] row, int interactionIndex) {
        List<String> combinedDomains = this._interaction_column_domains.get(this._interaction_targets[interactionIndex]);
        int predictor1Index = this._interactions_1[interactionIndex];
        int predictor2Index = this._interactions_2[interactionIndex];
        String[] predictor1Domains = this._domains[predictor1Index];
        String[] predictor2Domains = this._domains[predictor2Index];
        String predictor1Domain = predictor1Domains[(int)row[predictor1Index]];
        String predictor2Domain = predictor2Domains[(int)row[predictor2Index]];
        String combinedEnumDomains = predictor1Domain + "_" + predictor2Domain;
        if (combinedDomains.contains(combinedEnumDomains)) {
            return combinedDomains.indexOf(combinedEnumDomains);
        }
        return -1;
    }

    static enum InteractionTypes {
        ENUM_TO_ENUM,
        ENUM_TO_NUM,
        NUM_TO_NUM;

    }

    static class Strata
    implements Serializable {
        final double[] strata;
        final int strataLen;
        final int hashCode;

        public Strata(double[] strata, int strataLen) {
            this.strata = strata;
            int hash = 11;
            for (int i = 0; i < strataLen; ++i) {
                hash *= 13;
                hash += 17 * (int)strata[i];
            }
            this.hashCode = hash;
            this.strataLen = strataLen;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Strata that = (Strata)o;
            if (this.hashCode != that.hashCode) {
                return false;
            }
            if (this.strataLen != that.strataLen) {
                return false;
            }
            for (int i = 0; i < this.strataLen; ++i) {
                if ((int)this.strata[i] == (int)that.strata[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

