/*
 * Decompiled with CFR 0.152.
 */
package water.util.comparison.string;

import water.util.comparison.string.H2OJaroWinklerComparator;
import water.util.comparison.string.JaccardIndexComparator;
import water.util.comparison.string.LevenshteinDistanceComparator;
import water.util.comparison.string.LongestCommonSubstring;
import water.util.comparison.string.QGramComparator;
import water.util.comparison.string.SoundexComparator;
import water.util.comparison.string.StringComparator;

public class StringComparatorFactory {
    public static StringComparator makeComparator(String measure) {
        switch (measure) {
            case "jaccard": 
            case "JaccardIndex": {
                return new JaccardIndexComparator();
            }
            case "jw": 
            case "JaroWinkler": {
                return new H2OJaroWinklerComparator();
            }
            case "lv": 
            case "Levenshtein": {
                return new LevenshteinDistanceComparator();
            }
            case "lcs": 
            case "LongestCommonSubstring": {
                return new LongestCommonSubstring();
            }
            case "qgram": 
            case "QGram": {
                return new QGramComparator();
            }
            case "soundex": 
            case "Soundex": {
                return new SoundexComparator();
            }
        }
        throw new IllegalArgumentException("Unknown comparator: " + measure);
    }
}

