/*
 * Decompiled with CFR 0.152.
 */
package water.util.comparison.string;

import water.util.comparison.string.StringComparator;

public class SoundexComparator
implements StringComparator {
    private static char[] number = SoundexComparator.buildTable();

    @Override
    public double compare(String s1, String s2) {
        if (s1.equals(s2)) {
            return 1.0;
        }
        if (SoundexComparator.soundex(s1).equals(SoundexComparator.soundex(s2))) {
            return 0.9;
        }
        return 0.0;
    }

    @Override
    public boolean isTokenized() {
        return true;
    }

    public static String soundex(String str) {
        if (str.length() < 1) {
            return "";
        }
        char[] key = new char[4];
        key[0] = str.charAt(0);
        int pos = 1;
        char prev = '0';
        for (int ix = 1; ix < str.length() && pos < 4; ++ix) {
            int charno;
            char ch = str.charAt(ix);
            if (ch >= 'A' && ch <= 'Z') {
                charno = ch - 65;
            } else {
                if (ch < 'a' || ch > 'z') continue;
                charno = ch - 97;
            }
            if (number[charno] != '0' && number[charno] != prev) {
                key[pos++] = number[charno];
            }
            prev = number[charno];
        }
        while (pos < 4) {
            key[pos] = 48;
            ++pos;
        }
        return new String(key);
    }

    private static char[] buildTable() {
        char[] table = new char[26];
        for (int ix = 0; ix < table.length; ++ix) {
            table[ix] = 48;
        }
        table[1] = 49;
        table[15] = 49;
        table[5] = 49;
        table[21] = 49;
        table[2] = 50;
        table[18] = 50;
        table[10] = 50;
        table[6] = 50;
        table[9] = 50;
        table[16] = 50;
        table[23] = 50;
        table[25] = 50;
        table[3] = 51;
        table[19] = 51;
        table[11] = 52;
        table[12] = 53;
        table[13] = 53;
        table[17] = 54;
        return table;
    }
}

