/*
 * Decompiled with CFR 0.152.
 */
package water.util;

public class MarkdownBuilder {
    private StringBuffer sb = new StringBuffer();

    public StringBuffer append(StringBuffer s) {
        this.sb.append(s);
        return this.sb;
    }

    public StringBuffer append(String s) {
        this.sb.append(s);
        return this.sb;
    }

    public StringBuffer paragraph(String paragraph) {
        this.sb.append(paragraph).append("\n\n");
        return this.sb;
    }

    public StringBuffer hline() {
        this.sb.append("---\n");
        return this.sb;
    }

    private StringBuffer append(String separator, boolean addNewline, String ... strings) {
        int i = 0;
        for (String string : strings) {
            if (i++ > 0) {
                this.sb.append(separator);
            }
            this.sb.append(string);
        }
        if (addNewline) {
            this.sb.append("\n");
        }
        return this.sb;
    }

    public StringBuffer comment(String ... comment) {
        this.sb.append("[//]: # (");
        this.append(" ", false, comment);
        this.sb.append(")\n");
        return this.sb;
    }

    public StringBuffer heading1(String ... heading) {
        this.sb.append("# ");
        this.append(" ", true, heading);
        return this.sb;
    }

    public StringBuffer heading2(String ... heading) {
        this.sb.append("## ");
        this.append(" ", true, heading);
        return this.sb;
    }

    public StringBuffer tableRow(String ... cols) {
        this.append(" | ", true, cols);
        return this.sb;
    }

    public StringBuffer tableHeader(String ... cols) {
        this.tableRow(cols);
        int i = 0;
        for (String col : cols) {
            if (i++ > 0) {
                this.sb.append(" | ");
            }
            this.sb.append("---");
        }
        this.sb.append("\n");
        return this.sb;
    }

    public StringBuffer stringBuffer() {
        return this.sb;
    }

    public String toString() {
        return this.sb.toString();
    }
}

