/*
 * Decompiled with CFR 0.152.
 */
package water.server;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import water.H2O;
import water.init.AbstractEmbeddedH2OConfig;
import water.server.ServletService;
import water.webserver.iface.RequestAuthExtension;

public class LeaderNodeRequestFilter
implements RequestAuthExtension {
    private final Set<String> allowedContextPaths;

    public LeaderNodeRequestFilter() {
        HashSet<String> allowed = new HashSet<String>();
        allowed.addAll(ServletService.INSTANCE.getAlwaysEnabledServlets().keySet());
        allowed.addAll(ServletService.INSTANCE.getAllWebsockets().keySet());
        this.allowedContextPaths = Collections.unmodifiableSet(allowed);
    }

    public boolean handle(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (H2O.SELF == null) {
            response.sendError(403, "H2O Node didn't start yet. H2O API is inaccessible at the moment.");
        } else {
            if (H2O.SELF.isLeaderNode()) {
                return false;
            }
            if (this.allowedContextPaths.contains(target)) {
                return false;
            }
        }
        response.sendError(403, "Deployment configuration error - request reached a non-leader H2O node.");
        return true;
    }

    public boolean isEnabled() {
        AbstractEmbeddedH2OConfig config = H2O.getEmbeddedH2OConfig();
        return config != null && config.disableNonLeaderNodeAccess();
    }
}

