/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.HashMap;
import java.util.Map;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.util.UnsafeUtils;

public class CUDChunk
extends Chunk {
    public static int MAX_UNIQUES = 256;
    int numUniques;

    public static int computeByteSize(int uniques, int len) {
        return 8 + (uniques << 3) + (len << 1);
    }

    CUDChunk() {
    }

    CUDChunk(byte[] bs, HashMap<Long, Byte> hs, int len) {
        this._start = -1L;
        this.numUniques = hs.size();
        this.set_len(len);
        this._mem = MemoryManager.malloc1(CUDChunk.computeByteSize(this.numUniques, this._len), false);
        UnsafeUtils.set4(this._mem, 0, this._len);
        UnsafeUtils.set4(this._mem, 4, this.numUniques);
        int j = 0;
        for (Map.Entry<Long, Byte> e : hs.entrySet()) {
            e.setValue((byte)(j - 128));
            UnsafeUtils.set8(this._mem, 8 + (j << 3), e.getKey());
            ++j;
        }
        for (int i = 0; i < len; ++i) {
            UnsafeUtils.set1(this._mem, 8 + (this.numUniques << 3) + i, hs.get(Double.doubleToLongBits(UnsafeUtils.get8d(bs, i << 3))));
        }
    }

    @Override
    protected final long at8_impl(int i) {
        double res = this.atd_impl(i);
        if (Double.isNaN(res)) {
            throw new IllegalArgumentException("at8_impl but value is missing");
        }
        return (long)res;
    }

    @Override
    protected final double atd_impl(int i) {
        int whichUnique = UnsafeUtils.get1(this._mem, 8 + (this.numUniques << 3) + i) + 128;
        return Double.longBitsToDouble(UnsafeUtils.get8(this._mem, 8 + (whichUnique << 3)));
    }

    @Override
    public double[] getDoubles(double[] vals, int from, int to) {
        return this.getDoubles(vals, from, to, Double.NaN);
    }

    @Override
    public double[] getDoubles(double[] vals, int from, int to, double NA) {
        int i;
        double[] uniques = new double[this.numUniques];
        for (i = 0; i < this.numUniques; ++i) {
            uniques[i] = Double.longBitsToDouble(UnsafeUtils.get8(this._mem, 8 + (i << 3)));
            if (!Double.isNaN(uniques[i])) continue;
            uniques[i] = NA;
        }
        for (i = 0; i < this._len; ++i) {
            vals[i] = uniques[UnsafeUtils.get1(this._mem, 8 + (this.numUniques << 3) + i) + 128];
        }
        return vals;
    }

    @Override
    protected final boolean isNA_impl(int i) {
        return Double.isNaN(this.atd_impl(i));
    }

    @Override
    boolean set_impl(int idx, long l) {
        return false;
    }

    @Override
    boolean set_impl(int i, double d) {
        for (int j = 0; j < this.numUniques; ++j) {
            if (Double.compare(Double.doubleToLongBits(d), UnsafeUtils.get8(this._mem, 8 + (j << 3))) != 0) continue;
            UnsafeUtils.set1(this._mem, 8 + (this.numUniques << 3) + i, (byte)(j - 128));
            return true;
        }
        return false;
    }

    @Override
    boolean set_impl(int i, float f) {
        return this.set_impl(i, (double)f);
    }

    @Override
    boolean setNA_impl(int idx) {
        return this.set_impl(idx, Double.NaN);
    }

    public ChunkVisitor processRows(ChunkVisitor nc, int from, int to) {
        for (int i = from; i < to; ++i) {
            nc.addValue(this.atd(i));
        }
        return nc;
    }

    public ChunkVisitor processRows(ChunkVisitor nc, int ... rows) {
        for (int i : rows) {
            nc.addValue(this.atd(i));
        }
        return nc;
    }

    @Override
    protected final void initFromBytes() {
        this._start = -1L;
        this._cidx = -1;
        this._len = UnsafeUtils.get4(this._mem, 0);
        this.numUniques = UnsafeUtils.get4(this._mem, 4);
        this.set_len(this._len);
    }
}

