/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.Date;
import water.Iced;

public class Countdown
extends Iced<Countdown> {
    private long _time_limit_millis;
    private long _start_time;
    private long _stop_time;

    public static Countdown fromSeconds(double seconds) {
        return new Countdown(seconds <= 0.0 ? 0L : (long)Math.ceil(seconds * 1000.0));
    }

    public Countdown(long time_limit_millis) {
        this._time_limit_millis = time_limit_millis;
    }

    public Countdown(long _time_limit_millis, boolean start) {
        this(_time_limit_millis);
        if (start) {
            this.start();
        }
    }

    public Date start_time() {
        return new Date(this._start_time);
    }

    public Date stop_time() {
        return new Date(this._stop_time);
    }

    public long duration() {
        if (!this.ended()) {
            throw new IllegalStateException("Countdown was never started or stopped.");
        }
        return this.elapsedTime();
    }

    public void start() {
        if (this.running()) {
            throw new IllegalStateException("Countdown is already running.");
        }
        this.reset();
        this._start_time = this.now();
    }

    public boolean running() {
        return this._start_time > 0L && this._stop_time == 0L;
    }

    public boolean ended() {
        return this._start_time > 0L && this._stop_time > 0L;
    }

    public long stop() {
        if (this.running() && !this.ended()) {
            this._stop_time = this.now();
        }
        return this.elapsedTime();
    }

    public long elapsedTime() {
        if (this.running()) {
            return this.now() - this._start_time;
        }
        if (this.ended()) {
            return this._stop_time - this._start_time;
        }
        return 0L;
    }

    public long remainingTime() {
        if (this.running()) {
            return this._time_limit_millis > 0L ? Math.max(0L, this._start_time + this._time_limit_millis - this.now()) : Long.MAX_VALUE;
        }
        if (this.ended()) {
            return 0L;
        }
        return this._time_limit_millis > 0L ? this._time_limit_millis : Long.MAX_VALUE;
    }

    public void reset() {
        this._start_time = 0L;
        this._stop_time = 0L;
    }

    public boolean timedOut() {
        return this._start_time > 0L && this._time_limit_millis > 0L && this.elapsedTime() > this._time_limit_millis;
    }

    private long now() {
        return System.currentTimeMillis();
    }
}

