/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.assign;

import java.util.UUID;
import water.Iced;
import water.fvec.Chunk;
import water.fvec.Vec;

public class AstRecAsgnHelper {
    public static ValueSetter createValueSetter(Vec v, Object value) {
        if (value == null) {
            return new NAValueSetter();
        }
        switch (v.get_type()) {
            case 4: {
                return new CatValueSetter(v.domain(), value);
            }
            case 3: 
            case 5: {
                return new NumValueSetter(value);
            }
            case 2: {
                return new StrValueSetter(value);
            }
            case 1: {
                return new UUIDValueSetter(value);
            }
        }
        throw new IllegalArgumentException("Cannot create ValueSetter for a Vec of type = " + v.get_type_str());
    }

    private static class UUIDValueSetter
    extends ValueSetter {
        private UUID _val;

        public UUIDValueSetter() {
        }

        private UUIDValueSetter(Object val) {
            if (val instanceof String) {
                val = UUID.fromString((String)val);
            } else if (!(val instanceof UUID)) {
                throw new IllegalArgumentException("Value needs to be an UUID, value = " + val);
            }
            this._val = (UUID)val;
        }

        @Override
        public void setValue(Chunk chk, int idx) {
            chk.set(idx, this._val);
        }

        @Override
        public void setValue(Vec vec, long idx) {
            vec.set(idx, this._val);
        }
    }

    private static class StrValueSetter
    extends ValueSetter {
        private String _val;

        public StrValueSetter() {
        }

        private StrValueSetter(Object val) {
            if (!(val instanceof String)) {
                throw new IllegalArgumentException("Value needs to be string, value = " + val);
            }
            this._val = (String)val;
        }

        @Override
        public void setValue(Chunk chk, int idx) {
            chk.set(idx, this._val);
        }

        @Override
        public void setValue(Vec vec, long idx) {
            vec.set(idx, this._val);
        }
    }

    private static class NumValueSetter
    extends ValueSetter {
        private double _val;

        public NumValueSetter() {
        }

        private NumValueSetter(Object val) {
            if (!(val instanceof Number)) {
                throw new IllegalArgumentException("Value needs to be numeric, value = " + val);
            }
            this._val = ((Number)val).doubleValue();
        }

        @Override
        public void setValue(Chunk chk, int idx) {
            chk.set(idx, this._val);
        }

        @Override
        public void setValue(Vec vec, long idx) {
            vec.set(idx, this._val);
        }
    }

    private static class CatValueSetter
    extends ValueSetter {
        private int _val;

        public CatValueSetter() {
        }

        private CatValueSetter(String[] domain, Object val) {
            if (!(val instanceof String)) {
                throw new IllegalArgumentException("Value needs to be categorical, value = " + val);
            }
            int factorIdx = -1;
            for (int i = 0; i < domain.length; ++i) {
                if (!val.equals(domain[i])) continue;
                factorIdx = i;
                break;
            }
            if (factorIdx == -1) {
                throw new IllegalArgumentException("Value is not in the domain of the Vec, value = " + val);
            }
            this._val = factorIdx;
        }

        @Override
        public void setValue(Chunk chk, int idx) {
            chk.set(idx, this._val);
        }

        @Override
        public void setValue(Vec vec, long idx) {
            vec.set(idx, (double)this._val);
        }
    }

    private static class NAValueSetter
    extends ValueSetter {
        @Override
        public void setValue(Chunk chk, int idx) {
            chk.setNA(idx);
        }

        @Override
        public void setValue(Vec vec, long idx) {
            vec.setNA(idx);
        }
    }

    public static abstract class ValueSetter
    extends Iced<ValueSetter> {
        public abstract void setValue(Chunk var1, int var2);

        public abstract void setValue(Vec var1, long var2);
    }
}

