/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import water.DKV;
import water.DTask;
import water.Futures;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.MemoryManager;
import water.RPC;
import water.Value;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.BinaryMerge;
import water.rapids.SingleThreadRadixOrder;
import water.rapids.SplitByMSBLocal;

class SortCombine
extends DTask<SortCombine> {
    long _numRowsInResult = 0L;
    int[] _chunkSizes;
    double[] _timings;
    final FFSB _leftSB;
    private transient KeyOrder _leftKO;
    private transient long _leftFrom;
    private transient int _retBatchSize;
    private int[][] _numRowsPerCidx;
    private int _chunkNum;
    private boolean[] _stringCols;
    private boolean[] _intCols;
    final SingleThreadRadixOrder.OXHeader _leftSortedOXHeader;
    final long _mergeId;

    SortCombine(FFSB leftSB, SingleThreadRadixOrder.OXHeader leftSortedOXHeader, long mergeId) {
        this._leftSB = leftSB;
        this._mergeId = mergeId;
        int columnsInResult = this._leftSB._frame.numCols();
        this._stringCols = MemoryManager.mallocZ(columnsInResult);
        this._intCols = MemoryManager.mallocZ(columnsInResult);
        if (this._leftSB._frame != null) {
            for (int col = 0; col < this._leftSB._frame.numCols(); ++col) {
                if (this._leftSB._frame.vec(col).isInt()) {
                    this._intCols[col] = true;
                }
                if (!this._leftSB._frame.vec(col).isString()) continue;
                this._stringCols[col] = true;
            }
        }
        this._chunkNum = this._leftSB._frame.anyVec().nChunks();
        this._leftSortedOXHeader = leftSortedOXHeader;
    }

    @Override
    public void compute2() {
        this._timings = MemoryManager.malloc8d(20);
        long t0 = System.nanoTime();
        this._leftKO = new KeyOrder(this._leftSortedOXHeader, this._mergeId);
        this._leftKO.initKeyOrder(this._leftSB._msb, true);
        this._retBatchSize = (int)this._leftKO._batchSize;
        long leftN = this._leftSortedOXHeader._numRows;
        assert (leftN >= 1L);
        this._timings[0] = this._timings[0] + (double)(System.nanoTime() - t0) / 1.0E9;
        this._leftFrom = -1L;
        long leftTo = leftN;
        long retSize = leftTo - this._leftFrom - 1L;
        assert (retSize >= 0L);
        if (retSize == 0L) {
            this.tryComplete();
            return;
        }
        this._numRowsInResult = retSize;
        this.setPerNodeNumsToFetch();
        if (this._numRowsInResult > 0L) {
            this.createChunksInDKV(this._mergeId);
        }
        this.tryComplete();
    }

    private void setPerNodeNumsToFetch() {
        Vec anyVec = this._leftSB._frame.anyVec();
        int nbatch = this._leftKO._order.length;
        this._numRowsPerCidx = new int[nbatch][anyVec.nChunks()];
        for (int batchNum = 0; batchNum < nbatch; ++batchNum) {
            int batchSize = this._leftKO._order[batchNum].length;
            for (int index = 0; index < batchSize; ++index) {
                long globalRowNumber = this._leftKO._order[batchNum][index];
                int chkIdx = this._leftSB._vec.elem2ChunkIdx(globalRowNumber);
                long[] lArray = this._leftKO._perNodeNumRowsToFetch;
                int n = this._leftSB._chunkNode[chkIdx];
                lArray[n] = lArray[n] + 1L;
                int[] nArray = this._numRowsPerCidx[batchNum];
                int n2 = chkIdx;
                nArray[n2] = nArray[n2] + 1;
            }
        }
    }

    private void chunksPopulatePerChunk(long[][][] perNodeLeftRowsCidx, long[][][] perNodeLeftIndices) {
        int numBatch = this._leftKO._order.length;
        int[][] chkIndices = new int[numBatch][];
        for (int nbatch = 0; nbatch < numBatch; ++nbatch) {
            int sortedRowIndex = -1;
            chkIndices[nbatch] = new int[this._chunkNum];
            int batchSize = this._leftKO._order[nbatch].length;
            for (int batchNum = 0; batchNum < batchSize; ++batchNum) {
                long row = this._leftKO._order[nbatch][batchNum];
                int chkIdx = this._leftSB._vec.elem2ChunkIdx(row);
                perNodeLeftRowsCidx[nbatch][chkIdx][chkIndices[nbatch][chkIdx]] = row;
                perNodeLeftIndices[nbatch][chkIdx][chkIndices[nbatch][chkIdx]] = ++sortedRowIndex;
                int[] nArray = chkIndices[nbatch];
                int n = chkIdx;
                nArray[n] = nArray[n] + 1;
            }
        }
    }

    private void createChunksInDKV(long mergeId) {
        long t0 = System.nanoTime();
        int batchSizeUUID = this._retBatchSize;
        int nbatch = (int)((this._numRowsInResult - 1L) / (long)batchSizeUUID + 1L);
        int cloudSize = H2O.CLOUD.size();
        long[][][] perMSBLeftRowsCidx = new long[nbatch][this._chunkNum][];
        long[][][] perMSBLeftIndices = new long[nbatch][this._chunkNum][];
        for (int batchN = 0; batchN < nbatch; ++batchN) {
            for (int chkidx = 0; chkidx < this._chunkNum; ++chkidx) {
                perMSBLeftRowsCidx[batchN][chkidx] = new long[this._numRowsPerCidx[batchN][chkidx]];
                perMSBLeftIndices[batchN][chkidx] = new long[this._numRowsPerCidx[batchN][chkidx]];
            }
        }
        long t1 = System.nanoTime();
        this._timings[2] = this._timings[2] + (double)(t1 - t0) / 1.0E9;
        t0 = t1;
        this.chunksPopulatePerChunk(perMSBLeftRowsCidx, perMSBLeftIndices);
        t1 = System.nanoTime();
        this._timings[3] = this._timings[3] + (double)(t1 - t0) / 1.0E9;
        t0 = t1;
        assert (nbatch >= 1);
        int lastSize = (int)(this._numRowsInResult - (long)((nbatch - 1) * batchSizeUUID));
        assert (lastSize > 0);
        int numColsInResult = this._leftSB._frame.numCols();
        double[][][] frameLikeChunks = new double[numColsInResult][nbatch][];
        long[][][] frameLikeChunksLongs = new long[numColsInResult][nbatch][];
        BufferedString[][][] frameLikeChunks4Strings = new BufferedString[numColsInResult][nbatch][];
        this._chunkSizes = new int[nbatch];
        GetRawRemoteRowsPerChunk[][] grrrsLeftPerChunk = new GetRawRemoteRowsPerChunk[cloudSize][];
        for (int b = 0; b < nbatch; ++b) {
            this.allocateFrameLikeChunks(b, nbatch, lastSize, batchSizeUUID, frameLikeChunks, frameLikeChunks4Strings, frameLikeChunksLongs, numColsInResult);
            this.chunksPopulateRetFirstPerChunk(perMSBLeftRowsCidx, perMSBLeftIndices, b, grrrsLeftPerChunk, frameLikeChunks, frameLikeChunks4Strings, frameLikeChunksLongs);
            t1 = System.nanoTime();
            this._timings[10] = this._timings[10] + (double)(t1 - t0) / 1.0E9;
            t0 = t1;
            this.chunksCompressAndStore(b, numColsInResult, frameLikeChunks, frameLikeChunks4Strings, frameLikeChunksLongs, mergeId);
            if (nbatch <= 1) continue;
            this.cleanUpMemory(grrrsLeftPerChunk, b);
        }
        this._timings[11] = this._timings[11] + (double)(System.nanoTime() - t0) / 1.0E9;
    }

    private void chunksPopulateRetFirstPerChunk(long[][][] perMSBLeftRowsCidx, long[][][] perMSBLeftIndices, int jb, GetRawRemoteRowsPerChunk[][] grrrsLeft, double[][][] frameLikeChunks, BufferedString[][][] frameLikeChunks4String, long[][][] frameLikeChunksLong) {
        int ni;
        RPC[][] grrrsLeftRPC = new RPC[H2O.CLOUD.size()][];
        int batchSize = this._leftKO._order[jb].length;
        for (H2ONode node : H2O.CLOUD._memary) {
            ni = node.index();
            grrrsLeftRPC[ni] = new RPC[1];
            grrrsLeft[ni] = new GetRawRemoteRowsPerChunk[1];
            grrrsLeftRPC[ni][0] = new RPC<GetRawRemoteRowsPerChunk>(node, new GetRawRemoteRowsPerChunk(this._leftSB._frame, batchSize, perMSBLeftRowsCidx[jb], perMSBLeftIndices[jb])).call();
        }
        for (H2ONode node : H2O.CLOUD._memary) {
            ni = node.index();
            GetRawRemoteRowsPerChunk getRawRemoteRowsPerChunk = (GetRawRemoteRowsPerChunk)grrrsLeftRPC[ni][0].get();
            grrrsLeft[ni][0] = getRawRemoteRowsPerChunk;
            this._timings[5] = this._timings[5] + getRawRemoteRowsPerChunk.timeTaken;
        }
        for (H2ONode node : H2O.CLOUD._memary) {
            ni = node.index();
            long[][] chksLong = grrrsLeft[ni][0]._chkLong;
            double[][] chks = grrrsLeft[ni][0]._chk;
            BufferedString[][] chksString = grrrsLeft[ni][0]._chkString;
            for (int cidx = 0; cidx < this._chunkNum; ++cidx) {
                if (this._leftSB._chunkNode[cidx] != ni) continue;
                int rowSize = perMSBLeftIndices[jb][cidx].length;
                for (int row = 0; row < rowSize; ++row) {
                    for (int col = 0; col < chks.length; ++col) {
                        int offset = (int)perMSBLeftIndices[jb][cidx][row];
                        if (this._stringCols[col]) {
                            frameLikeChunks4String[col][jb][offset] = chksString[col][offset];
                            continue;
                        }
                        if (this._intCols[col]) {
                            frameLikeChunksLong[col][jb][offset] = chksLong[col][offset];
                            continue;
                        }
                        frameLikeChunks[col][jb][offset] = chks[col][offset];
                    }
                }
            }
        }
    }

    private void allocateFrameLikeChunks(int b, int nbatch, int lastSize, int batchSizeUUID, double[][][] frameLikeChunks, BufferedString[][][] frameLikeChunks4Strings, long[][][] frameLikeChunksLongs, int numColsInResult) {
        for (int col = 0; col < numColsInResult; ++col) {
            if (this._stringCols[col]) {
                this._chunkSizes[b] = b == nbatch - 1 ? lastSize : batchSizeUUID;
                frameLikeChunks4Strings[col][b] = new BufferedString[this._chunkSizes[b]];
                continue;
            }
            if (this._intCols[col]) {
                this._chunkSizes[b] = b == nbatch - 1 ? lastSize : batchSizeUUID;
                frameLikeChunksLongs[col][b] = MemoryManager.malloc8(this._chunkSizes[b]);
                Arrays.fill(frameLikeChunksLongs[col][b], Long.MIN_VALUE);
                continue;
            }
            this._chunkSizes[b] = b == nbatch - 1 ? lastSize : batchSizeUUID;
            frameLikeChunks[col][b] = MemoryManager.malloc8d(this._chunkSizes[b]);
            Arrays.fill(frameLikeChunks[col][b], Double.NaN);
        }
    }

    private void cleanUpMemory(GetRawRemoteRowsPerChunk[][] grrr, int batchIdx) {
        if (grrr != null) {
            int nodeNum = grrr.length;
            for (int nodeIdx = 0; nodeIdx < nodeNum; ++nodeIdx) {
                int batchLimit = Math.min(batchIdx + 1, grrr[nodeIdx].length);
                if (grrr[nodeIdx] == null || grrr[nodeIdx].length <= 0) continue;
                for (int bIdx = 0; bIdx < batchLimit; ++bIdx) {
                    int chkLen = grrr[nodeIdx][bIdx] == null ? 0 : (grrr[nodeIdx][bIdx]._chk == null ? 0 : grrr[nodeIdx][bIdx]._chk.length);
                    for (int cindex = 0; cindex < chkLen; ++cindex) {
                        grrr[nodeIdx][bIdx]._chk[cindex] = null;
                        grrr[nodeIdx][bIdx]._chkString[cindex] = null;
                        grrr[nodeIdx][bIdx]._chkLong[cindex] = null;
                    }
                    if (chkLen <= 0) continue;
                    grrr[nodeIdx][bIdx]._chk = null;
                    grrr[nodeIdx][bIdx]._chkString = null;
                    grrr[nodeIdx][bIdx]._chkLong = null;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void chunksCompressAndStore(int b, int numColsInResult, double[][][] frameLikeChunks, BufferedString[][][] frameLikeChunks4String, long[][][] frameLikeChunksLong, long mergeId) {
        Futures fs = new Futures();
        for (int col = 0; col < numColsInResult; ++col) {
            NewChunk nc;
            if (this._stringCols[col]) {
                void var11_12;
                nc = new NewChunk(null, 0);
                boolean bl = false;
                while (var11_12 < frameLikeChunks4String[col][b].length) {
                    nc.addStr(frameLikeChunks4String[col][b][var11_12]);
                    ++var11_12;
                }
                Chunk chunk = nc.compress();
                DKV.put(BinaryMerge.getKeyForMSBComboPerCol(this._leftSB._msb, -1, col, b, mergeId), chunk, fs, true);
                frameLikeChunks4String[col][b] = null;
                continue;
            }
            if (this._intCols[col]) {
                nc = new NewChunk(null, -1);
                for (long l : frameLikeChunksLong[col][b]) {
                    if (l == Long.MIN_VALUE) {
                        nc.addNA();
                        continue;
                    }
                    nc.addNum(l, 0);
                }
                Chunk chunk = nc.compress();
                DKV.put(BinaryMerge.getKeyForMSBComboPerCol(this._leftSB._msb, -1, col, b, mergeId), chunk, fs, true);
                frameLikeChunksLong[col][b] = null;
                continue;
            }
            Chunk ck2 = new NewChunk(frameLikeChunks[col][b]).compress();
            DKV.put(BinaryMerge.getKeyForMSBComboPerCol(this._leftSB._msb, -1, col, b, mergeId), ck2, fs, true);
            frameLikeChunks[col][b] = null;
        }
        fs.blockForPending();
    }

    static class GetRawRemoteRowsPerChunk
    extends DTask<GetRawRemoteRowsPerChunk> {
        Frame _fr;
        long[][] _perNodeLeftIndices;
        long[][] _perNodeLeftRowsCidx;
        double[][] _chk;
        BufferedString[][] _chkString;
        long[][] _chkLong;
        int _batchSize;
        int _nChunks;
        double timeTaken;

        GetRawRemoteRowsPerChunk(Frame fr, int batchSize, long[][] leftRowsCidx, long[][] leftRowsIndices) {
            this._fr = fr;
            this._batchSize = batchSize;
            this._perNodeLeftIndices = leftRowsIndices;
            this._perNodeLeftRowsCidx = leftRowsCidx;
            this._nChunks = this._perNodeLeftIndices.length;
        }

        private static long[][] malloc8A(int m, int n) {
            long[][] res = new long[m][];
            for (int i = 0; i < m; ++i) {
                res[i] = MemoryManager.malloc8(n);
            }
            return res;
        }

        @Override
        public void compute2() {
            assert (this._perNodeLeftIndices != null && this._perNodeLeftRowsCidx != null);
            assert (this._chk == null);
            long t0 = System.nanoTime();
            this._chk = MemoryManager.malloc8d(this._fr.numCols(), this._batchSize);
            this._chkLong = GetRawRemoteRowsPerChunk.malloc8A(this._fr.numCols(), this._batchSize);
            this._chkString = new BufferedString[this._fr.numCols()][this._batchSize];
            for (int cidx = 0; cidx < this._nChunks; ++cidx) {
                Vec v;
                for (int col = 0; col < this._fr.numCols() && (v = this._fr.vec(col)).chunkKey(cidx).home(); ++col) {
                    int offset;
                    int row;
                    Chunk c = v.chunkForChunkIdx(cidx);
                    int chunkSize = this._perNodeLeftRowsCidx[cidx].length;
                    if (v.isString()) {
                        for (row = 0; row < chunkSize; ++row) {
                            offset = (int)(this._perNodeLeftRowsCidx[cidx][row] - v.espc()[cidx]);
                            this._chkString[col][(int)this._perNodeLeftIndices[cidx][row]] = c.atStr(new BufferedString(), offset);
                        }
                        continue;
                    }
                    if (v.isInt()) {
                        for (row = 0; row < chunkSize; ++row) {
                            offset = (int)(this._perNodeLeftRowsCidx[cidx][row] - v.espc()[cidx]);
                            this._chkLong[col][(int)this._perNodeLeftIndices[cidx][row]] = c.isNA(offset) ? Long.MIN_VALUE : c.at8(offset);
                        }
                        continue;
                    }
                    for (row = 0; row < chunkSize; ++row) {
                        offset = (int)(this._perNodeLeftRowsCidx[cidx][row] - v.espc()[cidx]);
                        this._chk[col][(int)this._perNodeLeftIndices[cidx][row]] = c.atd(offset);
                    }
                }
            }
            this._perNodeLeftIndices = null;
            this._perNodeLeftRowsCidx = null;
            this._fr = null;
            assert (this._chk != null && this._chkLong != null && this._chkString != null);
            this.timeTaken = (double)(System.nanoTime() - t0) / 1.0E9;
            this.tryComplete();
        }
    }

    private static class KeyOrder {
        public final long _batchSize;
        private final transient byte[][] _key;
        private final transient long[][] _order;
        private final transient long[] _perNodeNumRowsToFetch;
        final long _mergeId;

        KeyOrder(SingleThreadRadixOrder.OXHeader sortedOXHeader, long mergeId) {
            this._batchSize = sortedOXHeader._batchSize;
            int nBatch = sortedOXHeader._nBatch;
            this._key = new byte[nBatch][];
            this._order = new long[nBatch][];
            this._perNodeNumRowsToFetch = new long[H2O.CLOUD.size()];
            this._mergeId = mergeId;
        }

        void initKeyOrder(int msb, boolean isLeft) {
            for (int b = 0; b < this._key.length; ++b) {
                Value v = DKV.get(SplitByMSBLocal.getSortedOXbatchKey(isLeft, msb, b, this._mergeId));
                SplitByMSBLocal.OXbatch ox = (SplitByMSBLocal.OXbatch)v.get();
                v.freeMem();
                this._key[b] = ox._x;
                this._order[b] = ox._o;
            }
        }
    }

    static class FFSB
    extends Iced<FFSB> {
        private final Frame _frame;
        private final Vec _vec;
        private final int[] _chunkNode;
        final int _msb;

        FFSB(Frame frame, int msb) {
            assert (-1 <= msb && msb <= 255);
            this._frame = frame;
            this._msb = msb;
            this._vec = frame.anyVec();
            Vec vec = this._vec;
            int[] nArray = this._chunkNode = vec == null ? null : MemoryManager.malloc4(vec.nChunks());
            if (vec == null) {
                return;
            }
            for (int i = 0; i < this._chunkNode.length; ++i) {
                this._chunkNode[i] = vec.chunkKey(i).home_node().index();
            }
        }
    }
}

