/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.Model;
import hex.grid.Grid;
import hex.grid.HyperSpaceSearchCriteria;
import hex.schemas.HyperSpaceSearchCriteriaV99;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import water.H2O;
import water.Key;
import water.api.API;
import water.api.Schema;
import water.api.schemas3.JobV3;
import water.api.schemas3.KeyV3;
import water.api.schemas3.ModelParametersSchemaV3;
import water.api.schemas3.SchemaV3;
import water.exceptions.H2OIllegalArgumentException;
import water.nbhm.NonBlockingHashMap;
import water.util.IcedHashMap;
import water.util.JSONUtils;

public class GridSearchSchema<G extends Grid<MP>, S extends GridSearchSchema<G, S, MP, P>, MP extends Model.Parameters, P extends ModelParametersSchemaV3>
extends SchemaV3<G, S> {
    @API(help="Basic model builder parameters.", direction=API.Direction.INPUT)
    public P parameters;
    @API(help="Grid search parameters.", direction=API.Direction.INOUT)
    public IcedHashMap<String, Object[]> hyper_parameters;
    @API(help="Destination id for this grid; auto-generated if not specified.", direction=API.Direction.INOUT)
    public KeyV3.GridKeyV3 grid_id;
    @API(help="Hyperparameter search criteria, including strategy and early stopping directives. If it is not given, exhaustive Cartesian is used.", direction=API.Direction.INOUT)
    public HyperSpaceSearchCriteriaV99 search_criteria;
    @API(help="Level of parallelism during grid model building. 1 = sequential building (default). 0 for adaptive parallelism. Any number > 1 sets the exact number of models built in parallel.")
    public int parallelism;
    @API(help="Path to a directory where grid will save everything necessary to resume training after cluster crash.", direction=API.Direction.INPUT)
    public String recovery_dir;
    @API(help="Key to use for the Job handling this GridSearch (internal use only).", direction=API.Direction.INPUT)
    public KeyV3.JobKeyV3 job_id;
    @API(help="Number of all models generated by grid search.", direction=API.Direction.OUTPUT)
    public int total_models;
    @API(help="Job Key.", direction=API.Direction.OUTPUT)
    public JobV3 job;
    private static final int SEQUENTIAL_GRID_SEARCH = 1;

    private static Map<String, Object[]> paramValuesToArray(Map<String, Object> params) {
        HashMap<String, Object[]> result = new HashMap<String, Object[]>();
        for (Map.Entry<String, Object> e : params.entrySet()) {
            Object[] objectArray;
            String k = e.getKey();
            Object v = e.getValue();
            if ("subspaces".equals(k)) {
                objectArray = ((List)v).stream().map(x -> GridSearchSchema.paramValuesToArray((Map)x)).toArray(Map[]::new);
            } else if (v instanceof List) {
                objectArray = ((List)v).toArray();
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = v;
            }
            Object[] arr = objectArray;
            k = GridSearchSchema.renameReservedWords(k);
            result.put(k, arr);
        }
        return result;
    }

    private static String renameReservedWords(String parm) {
        if (parm.endsWith("_") && parm.length() >= 2) {
            return parm.substring(0, parm.length() - 1);
        }
        return parm;
    }

    @Override
    public S fillFromParms(Properties parms) {
        if (parms.containsKey("hyper_parameters")) {
            try {
                NonBlockingHashMap<String, Object> m = JSONUtils.parse(parms.getProperty("hyper_parameters"));
                this.hyper_parameters.putAll(GridSearchSchema.paramValuesToArray(m));
            }
            catch (Exception e) {
                throw new H2OIllegalArgumentException("Can't parse the hyper_parameters dictionary; got error: " + e.getMessage() + " for raw value: " + parms.getProperty("hyper_parameters"));
            }
            parms.remove("hyper_parameters");
        }
        if (parms.containsKey("search_criteria")) {
            try {
                Properties p = JSONUtils.parseToProperties(parms.getProperty("search_criteria"));
                if (!p.containsKey("strategy")) {
                    throw new H2OIllegalArgumentException("search_criteria.strategy", "null");
                }
                HyperSpaceSearchCriteria.Strategy strategy = HyperSpaceSearchCriteria.Strategy.valueOf((String)p.get("strategy"));
                this.search_criteria = HyperSpaceSearchCriteriaV99.make(strategy);
                if (p.containsKey("max_runtime_secs") && Double.parseDouble((String)p.get("max_runtime_secs")) < 0.0) {
                    throw new H2OIllegalArgumentException("max_runtime_secs must be >= 0 (0 for unlimited time)", strategy.toString());
                }
                if (p.containsKey("max_models") && Integer.parseInt((String)p.get("max_models")) < 0) {
                    throw new H2OIllegalArgumentException("max_models must be >= 0 (0 for all models)", strategy.toString());
                }
                this.search_criteria.fillWithDefaults();
                this.search_criteria.fillFromParms(p);
            }
            catch (Exception e) {
                throw new H2OIllegalArgumentException("Can't parse the search_criteria dictionary; got error: " + e.getMessage() + " for raw value: " + parms.getProperty("search_criteria"));
            }
            parms.remove("search_criteria");
        } else {
            this.search_criteria = new HyperSpaceSearchCriteriaV99.CartesianSearchCriteriaV99();
        }
        if (parms.containsKey("grid_id")) {
            this.grid_id = new KeyV3.GridKeyV3(Key.make(parms.getProperty("grid_id")));
            parms.remove("grid_id");
        }
        if (parms.containsKey("parallelism")) {
            String parallelismProperty = parms.getProperty("parallelism");
            try {
                this.parallelism = Integer.parseInt(parallelismProperty);
                if (this.parallelism < 0) {
                    throw new IllegalArgumentException(String.format("Parallelism level must be >= 0. Given value: '%d'", this.parallelism));
                }
            }
            catch (NumberFormatException e) {
                String errorMessage = String.format("Could not parse given parallelism value: '%s' - not a number.", parallelismProperty);
                throw new IllegalArgumentException(errorMessage, e);
            }
            parms.remove("parallelism");
        } else {
            this.parallelism = 1;
        }
        if (parms.containsKey("recovery_dir")) {
            this.recovery_dir = parms.getProperty("recovery_dir");
            parms.remove("recovery_dir");
        }
        if (parms.containsKey("job_id")) {
            this.job_id = new KeyV3.JobKeyV3(Key.make(parms.getProperty("job_id")));
            parms.remove("job_id");
        }
        ((Schema)this.parameters).fillFromParms(parms, false);
        return (S)this;
    }

    @Override
    public S fillFromImpl(G impl) {
        throw H2O.unimpl();
    }
}

