/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.util.ArrayList;
import java.util.List;
import water.Key;
import water.exceptions.H2OUnsupportedDataFileException;
import water.fvec.ByteVec;
import water.parser.CsvParser;
import water.parser.DefaultParserProviders;
import water.parser.ParseDataset;
import water.parser.ParseSetup;
import water.util.ArrayUtils;

class ARFFParser
extends CsvParser {
    private static final String INCOMPLETE_HEADER = "@H20_INCOMPLETE_HEADER@";
    private static final String SKIP_NEXT_HEADER = "@H20_SKIP_NEXT_HEADER@";
    private static final String TAG_ATTRIBUTE = "@ATTRIBUTE";
    private static final String NA = "?";
    private static final byte GUESS_SEP = -1;
    private static final byte[] NON_DATA_LINE_MARKERS_DEFAULT = new byte[]{37, 64};

    ARFFParser(ParseSetup ps, Key jobKey) {
        super(ps, NON_DATA_LINE_MARKERS_DEFAULT, jobKey);
    }

    static ParseSetup guessSetup(ByteVec bv, byte[] bits, byte sep, boolean singleQuotes, String[] columnNames, String[][] naStrings, byte[] nonDataLineMarkers, byte escapechar) {
        if (columnNames != null) {
            throw new UnsupportedOperationException("ARFFParser doesn't accept columnNames.");
        }
        if (nonDataLineMarkers == null) {
            nonDataLineMarkers = NON_DATA_LINE_MARKERS_DEFAULT;
        }
        boolean haveData = false;
        String[][] data = new String[][]{};
        String[] headerlines = new String[]{};
        ArrayList<String> header = new ArrayList<String>();
        int offset = 0;
        int chunk_idx = 0;
        boolean readHeader = true;
        while (readHeader) {
            offset = ARFFParser.readArffHeader(0, header, bits, singleQuotes);
            if (ARFFParser.isValidHeader(header)) {
                String lastHeader = header.get(header.size() - 1);
                if (INCOMPLETE_HEADER.equals(lastHeader) || SKIP_NEXT_HEADER.equals(lastHeader)) {
                    bits = bv.chunkForChunkIdx(++chunk_idx).getBytes();
                    continue;
                }
            } else if (chunk_idx > 0) {
                throw new H2OUnsupportedDataFileException("Arff parsing: Invalid header. If compressed file, please try without compression", "First chunk was parsed correctly, but a following one failed, common with archives as only first chunk in decompressed");
            }
            readHeader = false;
        }
        if (offset < bits.length && !CsvParser.isEOL(bits[offset])) {
            haveData = true;
        }
        if (header.size() == 0) {
            throw new ParseDataset.H2OParseException("No data!");
        }
        headerlines = header.toArray(headerlines);
        int ncols = headerlines.length;
        String[] labels = new String[ncols];
        String[][] domains = new String[ncols][];
        byte[] ctypes = new byte[ncols];
        ARFFParser.processArffHeader(ncols, headerlines, labels, domains, ctypes);
        if (haveData) {
            int preview_max_length = 10;
            ArrayList<String> datablock = new ArrayList<String>();
            while (offset < bits.length && datablock.size() < 10) {
                String str;
                int lineStart = offset;
                while (offset < bits.length && !CsvParser.isEOL(bits[offset])) {
                    ++offset;
                }
                int lineEnd = offset++;
                if (offset < bits.length && bits[offset] == 10) {
                    ++offset;
                }
                if (ArrayUtils.contains(nonDataLineMarkers, bits[lineStart]) || lineEnd <= lineStart || (str = new String(bits, lineStart, lineEnd - lineStart).trim()).isEmpty()) continue;
                datablock.add(str);
            }
            if (datablock.size() == 0) {
                throw new ParseDataset.H2OParseException("Unexpected line.");
            }
            String[] datalines = datablock.toArray(new String[datablock.size()]);
            data = new String[datalines.length][];
            if (datalines.length == 1) {
                if (sep == -1) {
                    if (datalines[0].split(",").length > 2) {
                        sep = (byte)44;
                    } else if (datalines[0].split(" ").length > 2) {
                        sep = (byte)32;
                    } else {
                        throw new ParseDataset.H2OParseException("Failed to detect separator.");
                    }
                }
                data[0] = ARFFParser.determineTokens(datalines[0], sep, singleQuotes, escapechar);
                ncols = ncols > 0 ? ncols : data[0].length;
                labels = labels[0] == null ? null : labels;
            } else {
                if (sep == -1) {
                    sep = ARFFParser.guessSeparator(datalines[0], datalines[1], singleQuotes, escapechar);
                    if (sep == -1 && datalines.length > 2 && (sep = ARFFParser.guessSeparator(datalines[1], datalines[2], singleQuotes, escapechar)) == -1) {
                        sep = ARFFParser.guessSeparator(datalines[0], datalines[2], singleQuotes, escapechar);
                    }
                    if (sep == -1) {
                        sep = (byte)32;
                    }
                }
                for (int i = 0; i < datalines.length; ++i) {
                    data[i] = ARFFParser.determineTokens(datalines[i], sep, singleQuotes, escapechar);
                }
            }
        }
        naStrings = ARFFParser.addDefaultNAs(naStrings, ncols);
        return new ParseSetup(DefaultParserProviders.ARFF_INFO, sep, singleQuotes, -1, ncols, labels, ctypes, domains, naStrings, data, nonDataLineMarkers, escapechar);
    }

    private static String[][] addDefaultNAs(String[][] naStrings, int nCols) {
        String[][] nas = naStrings == null ? new String[nCols][] : naStrings;
        for (int i = 0; i < nas.length; ++i) {
            String[] colNas = nas[i];
            if (ArrayUtils.contains(colNas, NA)) continue;
            colNas = ArrayUtils.append(colNas, NA);
            nas[i] = colNas;
        }
        return nas;
    }

    private static boolean isValidHeader(List<String> header) {
        for (String line : header) {
            if (ARFFParser.isValidHeaderLine(line)) continue;
            return false;
        }
        return header.size() > 0;
    }

    private static boolean isValidHeaderLine(String str) {
        return str != null && str.startsWith("@");
    }

    private static int readArffHeader(int offset, List<String> header, byte[] bits, boolean singleQuotes) {
        String lastHeader = header.size() > 0 ? header.get(header.size() - 1) : null;
        boolean lastHeaderIncomplete = INCOMPLETE_HEADER.equals(lastHeader);
        boolean skipFirstLine = SKIP_NEXT_HEADER.equals(lastHeader);
        if (lastHeaderIncomplete || skipFirstLine) {
            header.remove(header.size() - 1);
        }
        String string = lastHeader = lastHeaderIncomplete ? header.remove(header.size() - 1) : null;
        while (offset < bits.length) {
            boolean lastLineIncomplete;
            int lineStart = offset;
            while (offset < bits.length && !CsvParser.isEOL(bits[offset])) {
                ++offset;
            }
            int lineEnd = offset++;
            if (offset < bits.length && bits[offset] == 10) {
                ++offset;
            }
            boolean bl = lastLineIncomplete = lineEnd == bits.length && !CsvParser.isEOL(bits[lineEnd - 1]);
            if (skipFirstLine) {
                skipFirstLine = false;
                if (!lastLineIncomplete) continue;
                header.add(SKIP_NEXT_HEADER);
                continue;
            }
            if (bits[lineStart] == 37 && !lastHeaderIncomplete) {
                if (!lastLineIncomplete) continue;
                header.add(SKIP_NEXT_HEADER);
                continue;
            }
            String str = new String(bits, lineStart, lineEnd - lineStart).trim();
            if (lastHeaderIncomplete) {
                str = lastHeader + str;
                lastHeaderIncomplete = false;
            } else {
                if (str.matches("(?i)^@relation\\s?.*$")) continue;
                if (str.matches("(?i)^@data\\s?.*$")) break;
            }
            if (str.isEmpty()) continue;
            header.add(str);
            if (!lastLineIncomplete) continue;
            header.add(INCOMPLETE_HEADER);
        }
        return offset;
    }

    static void processArffHeader(int ncols, String[] headerlines, String[] labels, String[][] domains, byte[] ctypes) {
        for (int i = 0; i < ncols; ++i) {
            String[] line = headerlines[i].split("\\s+", 2);
            if (!line[0].equalsIgnoreCase(TAG_ATTRIBUTE)) {
                throw new ParseDataset.H2OParseException("Expected line to start with @ATTRIBUTE.");
            }
            String spec = line.length == 2 ? line[1].replaceAll("\\s", " ") : "";
            int sepIdx = spec.lastIndexOf(32);
            if (sepIdx < 0) {
                throw new ParseDataset.H2OParseException("Expected @ATTRIBUTE to be followed by <attribute-name> <datatype>");
            }
            String type = spec.substring(sepIdx + 1).trim();
            domains[i] = null;
            ctypes[i] = 0;
            if (type.equalsIgnoreCase("NUMERIC") || type.equalsIgnoreCase("REAL") || type.equalsIgnoreCase("INTEGER") || type.equalsIgnoreCase("INT")) {
                ctypes[i] = 3;
            } else if (type.equalsIgnoreCase("DATE") || type.equalsIgnoreCase("TIME")) {
                ctypes[i] = 5;
            } else if (type.equalsIgnoreCase("ENUM")) {
                ctypes[i] = 4;
            } else if (type.equalsIgnoreCase("STRING")) {
                ctypes[i] = 2;
            } else if (type.equalsIgnoreCase("UUID")) {
                ctypes[i] = 1;
            } else {
                if (type.equalsIgnoreCase("RELATIONAL")) {
                    throw new UnsupportedOperationException("Relational ARFF format is not supported.");
                }
                if (type.endsWith("}")) {
                    int domainSpecStart = spec.lastIndexOf(123);
                    if (domainSpecStart < 0) {
                        throw new ParseDataset.H2OParseException("Invalid type specification.");
                    }
                    sepIdx = domainSpecStart - 1;
                    String domainSpec = spec.substring(domainSpecStart + 1, line[1].length() - 1);
                    domains[i] = domainSpec.split(",");
                    for (int j = 0; j < domains[i].length; ++j) {
                        domains[i][j] = domains[i][j].trim();
                    }
                    if (domains[i][0].length() > 0) {
                        ctypes[i] = 4;
                    }
                }
            }
            if (ctypes[i] == 0) {
                throw new ParseDataset.H2OParseException("Unexpected line, type not recognized. Attribute specification: " + type);
            }
            while (sepIdx > 0 && spec.charAt(sepIdx - 1) == ' ') {
                --sepIdx;
            }
            String label = line[1].substring(0, sepIdx);
            if (label.length() >= 2 && label.startsWith("'") && label.endsWith("'")) {
                label = label.substring(1, label.length() - 1);
            }
            labels[i] = label;
        }
    }
}

