/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import hex.Interaction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jsr166y.CountedCompleter;
import water.DKV;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.IcedHashMap;
import water.util.IcedLong;

public class CreateInteractions
extends H2O.H2OCountedCompleter {
    private final Interaction _ci;
    private static final int _missing = Integer.MIN_VALUE;
    static final String _other = "other";
    private Frame _target;
    private final Key<Job> _job;
    private Map<Long, Long> _sortedMap = null;

    public CreateInteractions(Interaction ci) {
        this._job = ci._job._key;
        this._ci = ci;
    }

    public CreateInteractions(int maxFactors, int minOccurrence) {
        this._job = null;
        this._ci = new Interaction();
        this._ci._max_factors = maxFactors;
        this._ci._min_occurrence = minOccurrence;
    }

    private static Map<Long, Long> mySort(Map<IcedLong, IcedLong> unsortMap) {
        LinkedList<Map.Entry<IcedLong, IcedLong>> list = new LinkedList<Map.Entry<IcedLong, IcedLong>>(unsortMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<IcedLong, IcedLong>>(){

            @Override
            public int compare(Map.Entry<IcedLong, IcedLong> o1, Map.Entry<IcedLong, IcedLong> o2) {
                return Long.valueOf(o2.getValue()._val).compareTo(o1.getValue()._val);
            }
        });
        LinkedHashMap<Long, Long> sortedMap = new LinkedHashMap<Long, Long>();
        for (Map.Entry entry : list) {
            sortedMap.put(((IcedLong)entry.getKey())._val, ((IcedLong)entry.getValue())._val);
        }
        return sortedMap;
    }

    public String[] makeDomain(Map<IcedLong, IcedLong> unsortedMap, String[] dA, String[] dB) {
        this._sortedMap = CreateInteractions.mySort(unsortedMap);
        long factorCount = 0L;
        String[] _domain = new String[this._sortedMap.size()];
        Iterator<Map.Entry<Long, Long>> it2 = this._sortedMap.entrySet().iterator();
        int d = 0;
        while (it2.hasNext()) {
            int b;
            Map.Entry<Long, Long> kv = it2.next();
            long ab = kv.getKey();
            long count = kv.getValue();
            if (factorCount >= (long)this._ci._max_factors || count < (long)this._ci._min_occurrence) break;
            ++factorCount;
            String feature = "";
            if (dA != dB) {
                int a = (int)(ab >> 32);
                String fA = a != Integer.MIN_VALUE ? dA[a] : "NA";
                feature = fA + "_";
            }
            String fB = (b = (int)ab) != Integer.MIN_VALUE ? dB[b] : "NA";
            feature = feature + fB;
            _domain[d++] = feature;
        }
        if (d < this._sortedMap.size()) {
            String[] copy = new String[d + 1];
            System.arraycopy(_domain, 0, copy, 0, d);
            copy[d] = _other;
            _domain = copy;
            LinkedHashMap<Long, Long> tm = new LinkedHashMap<Long, Long>();
            it2 = this._sortedMap.entrySet().iterator();
            while (--d >= 0) {
                Map.Entry<Long, Long> kv = it2.next();
                tm.put(kv.getKey(), kv.getValue());
            }
            this._sortedMap = tm;
        }
        return _domain;
    }

    private ArrayList<int[]> interactions() {
        ArrayList<int[]> al = new ArrayList<int[]>();
        if (!this._ci._pairwise || this._ci._factors.length < 3) {
            al.add(this._ci._factors);
        } else {
            for (int i = 0; i < this._ci._factors.length; ++i) {
                for (int j = i + 1; j < this._ci._factors.length; ++j) {
                    al.add(new int[]{this._ci._factors[i], this._ci._factors[j]});
                }
            }
        }
        return al;
    }

    public int work() {
        ArrayList<int[]> al = this.interactions();
        int work = 0;
        for (int l = 0; l < al.size(); ++l) {
            int start;
            int[] factors;
            for (int i = start = (factors = al.get(l)).length == 1 ? 0 : 1; i < factors.length; ++i) {
                ++work;
            }
        }
        return work;
    }

    @Override
    public void compute2() {
        DKV.remove(this._ci._job._result);
        Frame source_frame = (Frame)DKV.getGet(this._ci._source_frame);
        ArrayList<int[]> al = this.interactions();
        for (int l = 0; l < al.size(); ++l) {
            int[] factors = al.get(l);
            int idx1 = factors[0];
            Vec tmp = null;
            int start = factors.length == 1 ? 0 : 1;
            Frame _out = null;
            for (int i = start; i < factors.length; ++i) {
                String name;
                int idx2 = factors[i];
                if (i > 1) {
                    idx1 = _out.find(tmp);
                    assert (idx1 >= 0);
                    name = _out._names[idx1] + "_" + source_frame._names[idx2];
                } else {
                    name = source_frame._names[idx1] + "_" + source_frame._names[idx2];
                }
                Vec A = i > 1 ? _out.vecs()[idx1] : source_frame.vecs()[idx1];
                Vec B = source_frame.vecs()[idx2];
                createInteractionDomain pass1 = (createInteractionDomain)new createInteractionDomain(A._key.equals(B._key), this._ci._interactOnNA).doAll(A, B);
                Vec vec = source_frame.anyVec().makeZero(this.makeDomain(pass1._unsortedMap, A.domain(), B.domain()));
                if (i > 1) {
                    _out.add(name, vec);
                } else {
                    assert (_out == null);
                    _out = new Frame(new String[]{name}, new Vec[]{vec});
                }
                Vec C = _out.lastVec();
                long[] keys = new long[this._sortedMap.size()];
                int pos = 0;
                for (long k : this._sortedMap.keySet()) {
                    keys[pos++] = k;
                }
                assert (C.domain().length == keys.length || C.domain().length == keys.length + 1);
                new fillInteractionCategoricals(A._key.equals(B._key), keys).doAll(A, B, C);
                tmp = C;
                if (i > 1) {
                    int idx = _out.vecs().length - 2;
                    _out.remove(idx).remove();
                }
                this._ci._job.update(1L);
            }
            if (this._target == null) {
                this._target = new Frame(this._ci._job._result, _out.names(), _out.vecs());
                this._target.delete_and_lock((Key)this._job);
                continue;
            }
            this._target.add(_out);
        }
        this.tryComplete();
    }

    @Override
    public void onCompletion(CountedCompleter caller) {
        this._target.update(this._job);
        this._target.unlock(this._job);
    }

    private static class fillInteractionCategoricals
    extends MRTask<fillInteractionCategoricals> {
        boolean _same;
        final long[] _keys;
        private transient List<Map.Entry<Long, Integer>> _valToIndex;

        public fillInteractionCategoricals(boolean same, long[] keys) {
            this._same = same;
            this._keys = keys;
        }

        @Override
        protected void setupLocal() {
            this._valToIndex = new ArrayList<Map.Entry<Long, Integer>>();
            for (int i = 0; i < this._keys.length; ++i) {
                this._valToIndex.add(new AbstractMap.SimpleEntry<Long, Integer>(this._keys[i], i));
            }
            Collections.sort(this._valToIndex, new Comparator<Map.Entry<Long, Integer>>(){

                @Override
                public int compare(Map.Entry<Long, Integer> o1, Map.Entry<Long, Integer> o2) {
                    return o1.getKey().compareTo(o2.getKey());
                }
            });
        }

        @Override
        public void map(Chunk A, Chunk B, Chunk C) {
            for (int r = 0; r < A._len; ++r) {
                long ab;
                int a;
                int n = a = A.isNA(r) ? Integer.MIN_VALUE : (int)A.at8(r);
                if (!this._same) {
                    int b = B.isNA(r) ? Integer.MIN_VALUE : (int)B.at8(r);
                    ab = (long)a << 32 | (long)b & 0xFFFFFFFFL;
                } else {
                    ab = a;
                }
                if (this._same && A.isNA(r)) {
                    C.setNA(r);
                    continue;
                }
                int level = -1;
                int pos = Collections.binarySearch(this._valToIndex, new AbstractMap.SimpleEntry<Long, Integer>(ab, 0), new Comparator<Map.Entry<Long, Integer>>(){

                    @Override
                    public int compare(Map.Entry<Long, Integer> o1, Map.Entry<Long, Integer> o2) {
                        return o1.getKey().compareTo(o2.getKey());
                    }
                });
                if (pos >= 0) {
                    level = this._valToIndex.get(pos).getValue();
                    assert (this._keys[level] == ab);
                }
                if (level < 0) {
                    for (int i = 0; i < this._keys.length; ++i) {
                        assert (this._keys[i] != ab);
                    }
                    level = this._fr.lastVec().domain().length - 1;
                    assert (this._fr.lastVec().domain()[level].equals(CreateInteractions._other));
                }
                C.set(r, level);
            }
        }
    }

    public static class createInteractionDomain
    extends MRTask<createInteractionDomain> {
        private final boolean _same;
        private final boolean _interactOnNA;
        private final int[] _restrictedEnumA;
        private final int[] _restrictedEnumB;
        private IcedHashMap<IcedLong, IcedLong> _unsortedMap = null;

        public IcedHashMap<IcedLong, IcedLong> getMap() {
            return this._unsortedMap;
        }

        public createInteractionDomain(boolean same, boolean interactOnNA) {
            this._same = same;
            this._interactOnNA = interactOnNA;
            this._restrictedEnumB = null;
            this._restrictedEnumA = null;
        }

        public createInteractionDomain(boolean same, boolean interactOnNA, int[] restrictedEnumLeft, int[] restrictedEnumRite) {
            this._same = same;
            this._interactOnNA = interactOnNA;
            this._restrictedEnumA = restrictedEnumLeft;
            this._restrictedEnumB = restrictedEnumRite;
        }

        @Override
        public void map(Chunk A, Chunk B) {
            HashSet<Integer> restrictedB;
            this._unsortedMap = new IcedHashMap();
            HashSet<Integer> restrictedA = this._restrictedEnumA == null ? null : new HashSet<Integer>();
            HashSet<Integer> hashSet = restrictedB = this._restrictedEnumB == null ? null : new HashSet<Integer>();
            if (restrictedA != null) {
                for (int i : this._restrictedEnumA) {
                    restrictedA.add(i);
                }
            }
            if (restrictedB != null) {
                for (int i : this._restrictedEnumB) {
                    restrictedB.add(i);
                }
            }
            for (int r = 0; r < A._len; ++r) {
                IcedLong AB;
                long ab;
                int a;
                int n = a = A.isNA(r) ? Integer.MIN_VALUE : (int)A.at8(r);
                if (!this._interactOnNA && a == Integer.MIN_VALUE || restrictedA != null && !restrictedA.contains(a)) continue;
                if (!this._same) {
                    int b;
                    int n2 = b = B.isNA(r) ? Integer.MIN_VALUE : (int)B.at8(r);
                    if (!this._interactOnNA && b == Integer.MIN_VALUE || restrictedB != null && !restrictedB.contains(b)) continue;
                    ab = (long)a << 32 | (long)b & 0xFFFFFFFFL;
                    assert (a == (int)(ab >> 32));
                    assert (b == (int)ab);
                } else {
                    if (a == Integer.MIN_VALUE) continue;
                    ab = a;
                }
                if (this._unsortedMap.containsKey(AB = new IcedLong(ab))) {
                    ++((IcedLong)this._unsortedMap.get((Object)AB))._val;
                    continue;
                }
                this._unsortedMap.put(AB, new IcedLong(1L));
            }
        }

        @Override
        public void reduce(createInteractionDomain mrt) {
            assert (mrt._unsortedMap != null);
            assert (this._unsortedMap != null);
            for (Map.Entry e : mrt._unsortedMap.entrySet()) {
                IcedLong x = (IcedLong)this._unsortedMap.get(e.getKey());
                if (x != null) {
                    x._val += ((IcedLong)e.getValue())._val;
                    continue;
                }
                this._unsortedMap.put((IcedLong)e.getKey(), (IcedLong)e.getValue());
            }
            mrt._unsortedMap = null;
        }
    }
}

