/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.fvec.NewChunk;
import water.util.UnsafeUtils;

public class C4FChunk
extends Chunk {
    public C4FChunk(byte[] bs) {
        this._mem = bs;
        this._start = -1L;
        this.set_len(this._mem.length >> 2);
    }

    @Override
    protected final long at8_impl(int i) {
        float res = UnsafeUtils.get4f(this._mem, i << 2);
        if (Float.isNaN(res)) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return (long)res;
    }

    @Override
    protected final double atd_impl(int i) {
        float res = UnsafeUtils.get4f(this._mem, i << 2);
        return Float.isNaN(res) ? Double.NaN : (double)res;
    }

    @Override
    protected final boolean isNA_impl(int i) {
        return Float.isNaN(UnsafeUtils.get4f(this._mem, i << 2));
    }

    @Override
    boolean set_impl(int idx, long l) {
        return false;
    }

    @Override
    boolean set_impl(int i, double d) {
        return false;
    }

    @Override
    boolean set_impl(int i, float f) {
        UnsafeUtils.set4f(this._mem, i << 2, f);
        return true;
    }

    @Override
    boolean setNA_impl(int idx) {
        UnsafeUtils.set4f(this._mem, idx << 2, Float.NaN);
        return true;
    }

    @Override
    public NewChunk extractRows(NewChunk nc, int from, int to) {
        for (int i = from; i < to; ++i) {
            nc.addNum(UnsafeUtils.get4f(this._mem, 4 * i));
        }
        return nc;
    }

    @Override
    public NewChunk extractRows(NewChunk nc, int ... rows) {
        for (int i : rows) {
            nc.addNum(UnsafeUtils.get4f(this._mem, 4 * i));
        }
        return nc;
    }

    private final void processRow(int r, ChunkVisitor v) {
        float f = UnsafeUtils.get4f(this._mem, r << 2);
        if (Float.isNaN(f)) {
            v.addNAs(1);
        } else {
            v.addValue(f);
        }
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v, int from, int to) {
        for (int i = from; i < to; ++i) {
            this.processRow(i, v);
        }
        return v;
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v, int[] ids) {
        for (int i : ids) {
            this.processRow(i, v);
        }
        return v;
    }

    @Override
    public final void initFromBytes() {
        this._start = -1L;
        this._cidx = -1;
        this.set_len(this._mem.length >> 2);
        assert (this._mem.length == this._len << 2);
    }

    @Override
    public boolean hasFloat() {
        return true;
    }
}

