/*
 * Decompiled with CFR 0.152.
 */
package water.exceptions;

import water.H2OError;
import water.util.HttpResponseStatus;
import water.util.IcedHashMapGeneric;

public abstract class H2OAbstractRuntimeException
extends RuntimeException {
    public long timestamp = System.currentTimeMillis();
    public String dev_message;
    public IcedHashMapGeneric.IcedHashMapStringObject values;

    protected int HTTP_RESPONSE_CODE() {
        return HttpResponseStatus.BAD_REQUEST.getCode();
    }

    public H2OAbstractRuntimeException(String message, String dev_message, IcedHashMapGeneric.IcedHashMapStringObject values) {
        super(message);
        this.dev_message = dev_message;
        this.values = values;
    }

    public H2OAbstractRuntimeException(String msg, String dev_msg) {
        this(msg, dev_msg, new IcedHashMapGeneric.IcedHashMapStringObject());
    }

    public H2OError toH2OError() {
        return this.toH2OError(null);
    }

    public H2OError toH2OError(String error_url) {
        return new H2OError(this.timestamp, error_url, this.getMessage(), this.dev_message, this.HTTP_RESPONSE_CODE(), this.values, this);
    }
}

