/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import water.util.FileUtils;
import water.util.StringUtils;

public class NanoResponse {
    public String status;
    public String mimeType;
    public InputStream data;
    public Properties header = new Properties();

    public NanoResponse() {
        this.status = "200 OK";
    }

    public NanoResponse(String status, String mimeType, InputStream data) {
        this.status = status;
        this.mimeType = mimeType;
        this.data = data;
    }

    public NanoResponse(String status, String mimeType, String txt) {
        this(status, mimeType, StringUtils.bytesOf(txt));
    }

    public NanoResponse(String status, String mimeType, byte[] data) {
        this.status = status;
        this.mimeType = mimeType;
        this.data = new ByteArrayInputStream(data);
    }

    public void writeTo(OutputStream os) {
        FileUtils.copyStream(this.data, os, 1024);
    }

    public void addHeader(String name, String value) {
        this.header.put(name, value);
    }
}

