/*
 * Decompiled with CFR 0.152.
 */
package hex.leaderboard;

import hex.Model;
import hex.ModelCategory;
import hex.ModelContainer;
import hex.ModelMetrics;
import hex.leaderboard.LeaderboardCell;
import hex.leaderboard.LeaderboardColumn;
import hex.leaderboard.LeaderboardExtensionsProvider;
import hex.leaderboard.MetricScore;
import hex.leaderboard.ModelId;
import hex.leaderboard.ScoringTimePerRow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import water.DKV;
import water.Futures;
import water.Job;
import water.Key;
import water.Keyed;
import water.Lockable;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;
import water.logging.Logger;
import water.logging.LoggerFactory;
import water.util.ArrayUtils;
import water.util.DKVUtils;
import water.util.IcedHashMap;
import water.util.TwoDimTable;

public class Leaderboard
extends Lockable<Leaderboard>
implements ModelContainer<Model> {
    private static final Logger log = LoggerFactory.getLogger(Leaderboard.class);
    private transient Logger _eventLogger;
    private final String _project_name;
    private Key<Model>[] _model_keys = new Key[0];
    private final IcedHashMap<Key<ModelMetrics>, ModelMetrics> _leaderboard_model_metrics = new IcedHashMap();
    private IcedHashMap<String, double[]> _metric_values = new IcedHashMap();
    private LeaderboardExtensionsProvider _extensionsProvider;
    private LeaderboardCell[] _extensions_cells = new LeaderboardCell[0];
    private String _sort_metric;
    private ScoreData _score_data = ScoreData.auto;
    private String[] _metrics;
    private final Key<Frame> _leaderboard_frame_key;
    private final long _leaderboard_frame_checksum;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public static String idForProject(String project_name) {
        return "Leaderboard_" + project_name;
    }

    public static String idForProject(String project_name, ScoreData score_data) {
        if (ScoreData.auto.equals((Object)score_data)) {
            return Leaderboard.idForProject(project_name);
        }
        return "Leaderboard_" + project_name + "_for_" + score_data.toString();
    }

    public static boolean isLossFunction(String metric) {
        return metric != null && !Arrays.asList("auc", "aucpr").contains(metric.toLowerCase());
    }

    public static Leaderboard getInstance(Key leaderboardKey, Logger logger) {
        Leaderboard leaderboard = (Leaderboard)DKV.getGet(leaderboardKey);
        if (null != leaderboard && leaderboard._eventLogger == null) {
            leaderboard._eventLogger = logger == null ? log : logger;
        }
        return leaderboard;
    }

    public static Leaderboard getInstance(String projectName, Logger logger, Frame leaderboardFrame, String sortMetric, ScoreData scoreData) {
        Leaderboard leaderboard = Leaderboard.getInstance(Key.make(Leaderboard.idForProject(projectName, scoreData)), logger);
        if (null != leaderboard) {
            if (!(leaderboardFrame == null || leaderboardFrame._key.equals(leaderboard._leaderboard_frame_key) && leaderboardFrame.checksum() == leaderboard._leaderboard_frame_checksum)) {
                throw new H2OIllegalArgumentException("Cannot use leaderboard " + projectName + " with a new leaderboard frame (existing leaderboard frame: " + leaderboard._leaderboard_frame_key + ").");
            }
            if (sortMetric != null && !sortMetric.equals(leaderboard._sort_metric)) {
                leaderboard._sort_metric = sortMetric.toLowerCase();
                if (leaderboard.getLeader() != null) {
                    leaderboard.setDefaultMetrics(leaderboard.getLeader());
                }
            }
        }
        return leaderboard;
    }

    public static Leaderboard getOrMake(String projectName, Logger logger, Frame leaderboardFrame, String sortMetric, ScoreData scoreData) {
        Leaderboard leaderboard = Leaderboard.getInstance(projectName, logger, leaderboardFrame, sortMetric, scoreData);
        if (null == leaderboard) {
            leaderboard = new Leaderboard(projectName, logger, leaderboardFrame, sortMetric, scoreData);
        }
        DKV.put(leaderboard);
        return leaderboard;
    }

    public static Leaderboard getOrMake(String projectName, Logger logger, Frame leaderboardFrame, String sortMetric) {
        return Leaderboard.getOrMake(projectName, logger, leaderboardFrame, sortMetric, ScoreData.auto);
    }

    public Leaderboard(String projectName, Logger logger, Frame leaderboardFrame, String sortMetric, ScoreData scoreData) {
        super(Key.make(Leaderboard.idForProject(projectName, scoreData)));
        this._project_name = projectName;
        this._eventLogger = logger == null ? log : logger;
        this._leaderboard_frame_key = leaderboardFrame == null ? null : leaderboardFrame._key;
        this._leaderboard_frame_checksum = leaderboardFrame == null ? 0L : leaderboardFrame.checksum();
        this._sort_metric = sortMetric == null ? null : sortMetric.toLowerCase();
        this._score_data = scoreData;
    }

    public void setExtensionsProvider(LeaderboardExtensionsProvider provider) {
        this._extensionsProvider = provider;
    }

    public String getProject() {
        return this._project_name;
    }

    public String getSortMetric() {
        return this._sort_metric;
    }

    public String[] getMetrics() {
        String[] stringArray;
        if (this._metrics == null) {
            if (this._sort_metric == null) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this._sort_metric;
            }
        } else {
            stringArray = this._metrics;
        }
        return stringArray;
    }

    public Frame leaderboardFrame() {
        return this._leaderboard_frame_key == null ? null : this._leaderboard_frame_key.get();
    }

    @Override
    public Key<Model>[] getModelKeys() {
        return this._model_keys;
    }

    @Override
    public int getModelCount() {
        return this.getModelKeys() == null ? 0 : this.getModelKeys().length;
    }

    public Model[] getModels() {
        if (this.getModelCount() == 0) {
            return new Model[0];
        }
        return Leaderboard.getModelsFromKeys(this.getModelKeys());
    }

    public Model[] getModelsSortedByMetric(String metric) {
        if (this.getModelCount() == 0) {
            return new Model[0];
        }
        return Leaderboard.getModelsFromKeys(this.sortModelKeys(this.getModelKeys(), metric));
    }

    public Model getLeader() {
        if (this.getModelCount() == 0) {
            return null;
        }
        return this.getModelKeys()[0].get();
    }

    public int getModelRank(Key<Model> modelKey) {
        return ArrayUtils.find(this.getModelKeys(), modelKey) + 1;
    }

    public double[] getSortMetricValues() {
        return this._sort_metric == null ? null : (double[])this._metric_values.get(this._sort_metric);
    }

    public double[] getMetricValues(String metricName) {
        return (double[])this._metric_values.get(metricName);
    }

    private void setDefaultMetrics(Model m) {
        int sortMetricIdx;
        this.write_lock();
        String[] metrics = Leaderboard.defaultMetricsForModel(m);
        if (this._sort_metric == null) {
            String string = this._sort_metric = metrics.length > 0 ? metrics[0] : "mse";
        }
        if ((sortMetricIdx = ArrayUtils.find(metrics, this._sort_metric)) > 0) {
            metrics = ArrayUtils.remove(metrics, sortMetricIdx);
            metrics = ArrayUtils.prepend(metrics, this._sort_metric);
        } else if (sortMetricIdx < 0) {
            metrics = ArrayUtils.append(new String[]{this._sort_metric}, metrics);
        }
        this._metrics = metrics;
        this.update();
        this.unlock();
    }

    public ModelMetrics getOrCreateModelMetrics(Key<Model> modelKey) {
        return this.getOrCreateModelMetrics(modelKey, this.getExtensionsAsMap());
    }

    private ModelMetrics getModelMetrics(Model model) {
        switch (this._score_data) {
            case auto: {
                return ModelMetrics.defaultModelMetrics(model);
            }
            case xval: {
                return ((Model.Output)model._output)._cross_validation_metrics;
            }
            case valid: {
                return ((Model.Output)model._output)._validation_metrics;
            }
            case train: {
                return ((Model.Output)model._output)._training_metrics;
            }
        }
        throw new H2OIllegalArgumentException("Unsupported score data argument: " + (Object)((Object)this._score_data) + ". Use one of: auto, xval, valid, train.");
    }

    private ModelMetrics getOrCreateModelMetrics(Key<Model> modelKey, Map<Key<Model>, LeaderboardCell[]> extensions) {
        ModelMetrics mm;
        Frame leaderboardFrame = this.leaderboardFrame();
        Model model = modelKey.get();
        if (leaderboardFrame == null) {
            mm = this.getModelMetrics(model);
        } else {
            LeaderboardCell scoringTimePerRow;
            mm = ModelMetrics.getFromDKV(model, leaderboardFrame);
            if (mm == null && (scoringTimePerRow = this.getExtension(modelKey, ScoringTimePerRow.COLUMN.getName(), extensions)) != null && scoringTimePerRow.getValue() == null) {
                scoringTimePerRow.fetch();
                mm = ModelMetrics.getFromDKV(model, leaderboardFrame);
            }
            if (mm == null) {
                model.score(leaderboardFrame).delete();
                mm = ModelMetrics.getFromDKV(model, leaderboardFrame);
            }
        }
        return mm;
    }

    public void addModels(Key<Model>[] modelKeys) {
        if (modelKeys == null || modelKeys.length == 0) {
            return;
        }
        if (null == this._key) {
            throw new H2OIllegalArgumentException("Can't add models to a Leaderboard which isn't in the DKV.");
        }
        Key<Model>[] oldModelKeys = this._model_keys;
        Key<Model> oldLeaderKey = oldModelKeys == null || 0 == oldModelKeys.length ? null : oldModelKeys[0];
        HashSet<Key<Model>> uniques = new HashSet<Key<Model>>(Arrays.asList(ArrayUtils.append(oldModelKeys, modelKeys)));
        ArrayList<Key<Model>> allModelKeys = new ArrayList<Key<Model>>(uniques);
        HashSet<Key<Model>> newModelKeys = new HashSet<Key<Model>>(uniques);
        newModelKeys.removeAll(Arrays.asList(oldModelKeys));
        if (newModelKeys.isEmpty()) {
            return;
        }
        allModelKeys.forEach(DKV::prefetch);
        ModelCategory[] allowedModelCategories = new ModelCategory[]{ModelCategory.Binomial, ModelCategory.Multinomial, ModelCategory.Regression};
        for (Key key : newModelKeys) {
            Model m = (Model)key.get();
            if (m == null) continue;
            assert (m.isSupervised()) : "Leaderboard supports only supervised models!";
            assert (ArrayUtils.contains(allowedModelCategories, ((Model.Output)m._output).getModelCategory())) : "Leaderboard doesn't support " + ((Model.Output)m._output).getModelCategory() + " model category!";
            this._eventLogger.debug("Adding model " + key + " to leaderboard " + this._key + ". Training time: model=" + Math.round((double)((Model.Output)m._output)._run_time / 1000.0) + "s, total=" + Math.round((double)((Model.Output)m._output)._total_run_time / 1000.0) + "s");
        }
        ArrayList<ModelMetrics> modelMetrics = new ArrayList<ModelMetrics>();
        HashMap<Key<Model>, LeaderboardCell[]> hashMap = new HashMap<Key<Model>, LeaderboardCell[]>();
        ArrayList<Key> badKeys = new ArrayList<Key>();
        for (Key key : allModelKeys) {
            Model model = (Model)key.get();
            if (model == null) {
                badKeys.add(key);
                this._eventLogger.warn("Model `" + key + "` has unexpectedly been deleted from H2O: ignoring the model and/or removing it from the leaderboard.");
                continue;
            }
            if (this._extensionsProvider != null) {
                hashMap.put(key, this._extensionsProvider.createExtensions(model));
            }
            ModelMetrics mm = this.getOrCreateModelMetrics(key, hashMap);
            assert (mm != null) : "Missing metrics for model " + key;
            if (mm == null) {
                badKeys.add(key);
                this._eventLogger.warn("Metrics for model `" + key + "` are missing: ignoring the model and/or removing it from the leaderboard.");
                continue;
            }
            modelMetrics.add(mm);
        }
        if (this._metrics == null) {
            Model model = null;
            String string = ((Model.Parameters)modelKeys[0].get()._parms)._custom_metric_func;
            Object[] metricsFirst = Leaderboard.defaultMetricsForModel(modelKeys[0].get());
            for (Key<Model> k : modelKeys) {
                model = k.get();
                Object[] metrics = Leaderboard.defaultMetricsForModel(model);
                if (metrics.length != metricsFirst.length || !Arrays.equals(metricsFirst, metrics)) {
                    throw new H2OIllegalArgumentException("Models don't have the same metrics (e.g. model \"" + modelKeys[0].toString() + "\" and model \"" + k + "\").");
                }
                if (Objects.equals(string, ((Model.Parameters)k.get()._parms)._custom_metric_func)) continue;
                throw new H2OIllegalArgumentException("Models don't have the same custom metrics (e.g. model \"" + modelKeys[0].toString() + "\" and model \"" + k + "\").");
            }
            this.setDefaultMetrics(model);
        }
        for (Key key : badKeys) {
            allModelKeys.remove(key);
            hashMap.remove(key);
        }
        this.atomicUpdate(() -> {
            this._leaderboard_model_metrics.clear();
            modelMetrics.forEach(this::addModelMetrics);
            this.updateModels(allModelKeys.toArray(new Key[0]));
            this._extensions_cells = new LeaderboardCell[0];
            extensions.forEach(this::addExtensions);
        }, null);
        if (oldLeaderKey == null || !oldLeaderKey.equals(this._model_keys[0])) {
            this._eventLogger.info("New leader: " + this._model_keys[0] + ", " + this._sort_metric + ": " + ((double[])this._metric_values.get(this._sort_metric))[0]);
        }
    }

    public void removeModels(Key<Model>[] modelKeys, boolean cascade) {
        if (modelKeys == null || modelKeys.length == 0 || Arrays.stream(modelKeys).noneMatch(k -> ArrayUtils.contains(this._model_keys, k))) {
            return;
        }
        Arrays.stream(modelKeys).filter(k -> ArrayUtils.contains(this._model_keys, k)).forEach(k -> this._eventLogger.debug("Removing model " + k + " from leaderboard " + this._key));
        Key[] remainingKeys = (Key[])Arrays.stream(this._model_keys).filter(k -> !ArrayUtils.contains(modelKeys, k)).toArray(Key[]::new);
        this.atomicUpdate(() -> {
            this._model_keys = new Key[0];
            this.addModels(remainingKeys);
        }, null);
        if (cascade) {
            for (Key<Model> key : modelKeys) {
                Keyed.remove(key);
            }
        }
    }

    public void ensureSorted() {
        this.atomicUpdate(() -> this.updateModels(this._model_keys), null);
    }

    private void updateModels(Key<Model>[] modelKeys) {
        Key<Model>[] sortedModelKeys = this.sortModelKeys(modelKeys, this._sort_metric);
        Model[] sortedModels = Leaderboard.getModelsFromKeys(sortedModelKeys);
        IcedHashMap<String, double[]> metricValues = new IcedHashMap<String, double[]>();
        for (String metric : this._metrics) {
            metricValues.put(metric, this.getMetrics(metric, sortedModels));
        }
        this._metric_values = metricValues;
        this._model_keys = sortedModelKeys;
    }

    private void atomicUpdate(Runnable update, Key<Job> jobKey) {
        DKVUtils.atomicUpdate(this, update, jobKey, this.lock);
    }

    public <M extends Model> void addModel(Key<M> key) {
        if (key == null) {
            return;
        }
        this.addModels(new Key[]{key});
    }

    public <M extends Model> void removeModel(Key<M> key, boolean cascade) {
        if (key == null) {
            return;
        }
        this.removeModels(new Key[]{key}, cascade);
    }

    private void addModelMetrics(ModelMetrics modelMetrics) {
        if (modelMetrics != null) {
            this._leaderboard_model_metrics.put(modelMetrics._key, modelMetrics);
        }
    }

    private <M extends Model> void addExtensions(Key<M> key, LeaderboardCell ... extensions) {
        if (key == null) {
            return;
        }
        assert (ArrayUtils.contains(this._model_keys, key));
        LeaderboardCell[] toAdd = (LeaderboardCell[])Stream.of(extensions).filter(lc -> this.getExtension(key, lc.getColumn().getName()) == null).toArray(LeaderboardCell[]::new);
        this._extensions_cells = ArrayUtils.append(this._extensions_cells, toAdd);
    }

    /*
     * Exception decompiling
     */
    public Map<Key<Model>, LeaderboardCell[]> getExtensionsAsMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <M extends Model> LeaderboardCell[] getExtensions(Key<M> key) {
        return (LeaderboardCell[])Stream.of(this._extensions_cells).filter(c -> c.getModelId().equals(key)).toArray(LeaderboardCell[]::new);
    }

    private <M extends Model> LeaderboardCell getExtension(Key<M> key, String extName) {
        return this.getExtension(key, extName, Collections.singletonMap(key, this.getExtensions(key)));
    }

    private <M extends Model> LeaderboardCell getExtension(Key<M> key, String extName, Map<Key<Model>, LeaderboardCell[]> extensions) {
        if (extensions != null && extensions.containsKey(key)) {
            return Stream.of((Object[])extensions.get(key)).filter(le -> le.getColumn().getName().equals(extName)).findFirst().orElse(null);
        }
        return null;
    }

    private static Model[] getModelsFromKeys(Key<Model>[] modelKeys) {
        Model[] models = new Model[modelKeys.length];
        int i = 0;
        for (Key<Model> modelKey : modelKeys) {
            models[i++] = (Model)DKV.getGet(modelKey);
        }
        return models;
    }

    private Key<Model>[] sortModelKeys(Key<Model>[] modelKeys, String sortMetric) {
        boolean sortDecreasing = !Leaderboard.isLossFunction(sortMetric);
        Comparator<Key> cmp = Comparator.comparingDouble(mk -> this.getMetric(sortMetric, (Model)mk.get()));
        if (sortDecreasing) {
            cmp = cmp.reversed();
        }
        modelKeys = (Key[])modelKeys.clone();
        Arrays.sort(modelKeys, cmp);
        return modelKeys;
    }

    private double getMetric(String metric, Model model) {
        if (this.leaderboardFrame() != null) {
            return ModelMetrics.getMetricFromModelMetric((ModelMetrics)this._leaderboard_model_metrics.get(ModelMetrics.buildKey(model, this.leaderboardFrame())), metric);
        }
        return ModelMetrics.getMetricFromModelMetric(this.getModelMetrics(model), metric);
    }

    private double[] getMetrics(String metric, Model[] models) {
        double[] metrics = new double[models.length];
        int i = 0;
        for (Model m : models) {
            metrics[i++] = this.getMetric(metric, m);
        }
        return metrics;
    }

    @Override
    protected Futures remove_impl(Futures fs, boolean cascade) {
        log.debug("Cleaning up leaderboard from models " + Arrays.toString(this._model_keys));
        if (cascade) {
            for (Key<Model> m : this._model_keys) {
                Keyed.remove(m, fs, true);
            }
        }
        for (Key k : this._leaderboard_model_metrics.keySet()) {
            Keyed.remove(k, fs, true);
        }
        return super.remove_impl(fs, cascade);
    }

    private static String[] defaultMetricsForModel(Model m) {
        ArrayList<String> result = new ArrayList<String>();
        if (((Model.Output)m._output).isBinomialClassifier()) {
            Collections.addAll(result, "auc", "logloss", "aucpr", "mean_per_class_error", "rmse", "mse");
        } else if (((Model.Output)m._output).isMultinomialClassifier()) {
            Collections.addAll(result, "mean_per_class_error", "logloss", "rmse", "mse");
        } else if (((Model.Output)m._output).isSupervised()) {
            Collections.addAll(result, "rmse", "mse", "mae", "rmsle", "mean_residual_deviance");
        }
        if (((Model.Parameters)m._parms)._custom_metric_func != null) {
            result.add("custom");
        }
        return result.toArray(new String[0]);
    }

    private double[] getModelMetricValues(int rank) {
        assert (rank >= 0 && rank < this.getModelKeys().length) : "invalid rank";
        if (this._metrics == null) {
            return new double[0];
        }
        double[] values = new double[this._metrics.length];
        for (int i = 0; i < this._metrics.length; ++i) {
            values[i] = ((double[])this._metric_values.get(this._metrics[i]))[rank];
        }
        return values;
    }

    public String rankTsv() {
        String lineSeparator = "\n";
        StringBuilder sb = new StringBuilder();
        sb.append("Error").append(lineSeparator);
        for (int i = this.getModelKeys().length - 1; i >= 0; --i) {
            sb.append(Arrays.toString(this.getModelMetricValues(i)));
            sb.append(lineSeparator);
        }
        return sb.toString();
    }

    private TwoDimTable makeTwoDimTable(String tableHeader, int nrows, LeaderboardColumn ... columns) {
        assert (columns.length > 0);
        assert (this._sort_metric != null || nrows == 0) : "sort_metrics needs to be always not-null for non-empty array!";
        String description = nrows > 0 ? "models sorted in order of " + this._sort_metric + ", best first" : "no models in this leaderboard";
        String[] rowHeaders = new String[nrows];
        for (int i = 0; i < nrows; ++i) {
            rowHeaders[i] = "" + i;
        }
        String[] colHeaders = (String[])Stream.of(columns).map(LeaderboardColumn::getName).toArray(String[]::new);
        String[] colTypes = (String[])Stream.of(columns).map(LeaderboardColumn::getType).toArray(String[]::new);
        String[] colFormats = (String[])Stream.of(columns).map(LeaderboardColumn::getFormat).toArray(String[]::new);
        String colHeaderForRowHeader = nrows > 0 ? "#" : "-";
        return new TwoDimTable(tableHeader, description, rowHeaders, colHeaders, colTypes, colFormats, colHeaderForRowHeader);
    }

    private void addTwoDimTableRow(TwoDimTable table, int row, String modelID, String[] metrics, LeaderboardCell[] extensions) {
        int col = 0;
        table.set(row, col++, modelID);
        for (String metric : metrics) {
            double value = ((double[])this._metric_values.get(metric))[row];
            table.set(row, col++, value);
        }
        for (LeaderboardCell extension : extensions) {
            if (extension != null) {
                Object value;
                Object v = value = extension.getValue() == null ? extension.fetch() : extension.getValue();
                if (!extension.isNA()) {
                    table.set(row, col, value);
                }
            }
            ++col;
        }
    }

    public TwoDimTable toTwoDimTable(String ... extensions) {
        return this.toTwoDimTable("Leaderboard for project " + this._project_name, false, extensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TwoDimTable toTwoDimTable(String tableHeader, boolean leftJustifyModelIds, String ... extensions) {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        if (readLock.tryLock()) {
            try {
                Key[] modelKeys = (Key[])this._model_keys.clone();
                List<LeaderboardColumn> columns = this.getDefaultTableColumns();
                ArrayList extColumns = new ArrayList();
                if (this.getModelCount() > 0) {
                    Key<Model> leader = this.getModelKeys()[0];
                    LeaderboardCell[] extCells = extensions.length > 0 && "ALL".equalsIgnoreCase(extensions[0]) ? (LeaderboardCell[])Stream.of(this.getExtensions(leader)).filter(cell -> !cell.getColumn().isHidden()).toArray(LeaderboardCell[]::new) : (LeaderboardCell[])Stream.of(extensions).map(e -> this.getExtension((Key)leader, (String)e)).toArray(LeaderboardCell[]::new);
                    Stream.of(extCells).filter(Objects::nonNull).forEach(e -> extColumns.add(e.getColumn()));
                }
                columns.addAll(extColumns);
                TwoDimTable table = this.makeTwoDimTable(tableHeader, modelKeys.length, columns.toArray(new LeaderboardColumn[0]));
                int maxModelIdLen = Stream.of(modelKeys).mapToInt(k -> k.toString().length()).max().orElse(0);
                String[] modelIDsFormatted = new String[modelKeys.length];
                for (int i = 0; i < modelKeys.length; ++i) {
                    Key key = modelKeys[i];
                    modelIDsFormatted[i] = leftJustifyModelIds ? StringUtils.rightPad((String)key.toString(), (int)maxModelIdLen) : key.toString();
                    this.addTwoDimTableRow(table, i, modelIDsFormatted[i], this.getMetrics(), (LeaderboardCell[])extColumns.stream().map(ext -> this.getExtension(key, ext.getName())).toArray(LeaderboardCell[]::new));
                }
                TwoDimTable twoDimTable = table;
                return twoDimTable;
            }
            finally {
                readLock.unlock();
            }
        }
        return this.makeTwoDimTable(tableHeader, 0, this.getDefaultTableColumns().toArray(new LeaderboardColumn[0]));
    }

    private List<LeaderboardColumn> getDefaultTableColumns() {
        ArrayList<LeaderboardColumn> columns = new ArrayList<LeaderboardColumn>();
        columns.add(ModelId.COLUMN);
        for (String metric : this.getMetrics()) {
            columns.add(MetricScore.getColumn(metric));
        }
        return columns;
    }

    private String toString(String fieldSeparator, String lineSeparator, boolean includeTitle, boolean includeHeader) {
        StringBuilder sb = new StringBuilder();
        if (includeTitle) {
            sb.append("Leaderboard for project \"").append(this._project_name).append("\": ");
            if (this._model_keys.length == 0) {
                sb.append("<empty>");
                return sb.toString();
            }
            sb.append(lineSeparator);
        }
        boolean printedHeader = false;
        for (int i = 0; i < this._model_keys.length; ++i) {
            Key<Model> key = this._model_keys[i];
            if (includeHeader && !printedHeader) {
                sb.append("model_id");
                sb.append(fieldSeparator);
                Object[] metrics = this._metrics != null ? this._metrics : new String[]{};
                sb.append(Arrays.toString(metrics));
                sb.append(lineSeparator);
                printedHeader = true;
            }
            sb.append(key.toString());
            sb.append(fieldSeparator);
            double[] values = this._metrics != null ? this.getModelMetricValues(i) : new double[]{};
            sb.append(Arrays.toString(values));
            sb.append(lineSeparator);
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(" ; ", " | ", true, true);
    }

    public String toLogString() {
        return this.toTwoDimTable("Leaderboard for project " + this._project_name, true, new String[0]).toString();
    }

    private static /* synthetic */ LeaderboardCell[] lambda$getExtensionsAsMap$12(LeaderboardCell[] lhs, LeaderboardCell[] rhs) {
        return ArrayUtils.append(lhs, rhs);
    }

    public static enum ScoreData {
        auto,
        xval,
        train,
        valid;

    }
}

