/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.Arrays;

public class SetOfBytes {
    private boolean[] bits = new boolean[256];

    public SetOfBytes(byte[] bytes) {
        for (byte b : bytes) {
            this.bits[0xFF & b] = true;
        }
    }

    public SetOfBytes(String s) {
        this(s.getBytes());
    }

    public boolean contains(int b) {
        return b < 256 && b > -129 && this.bits[0xFF & b];
    }

    public boolean equals(Object other) {
        return other instanceof SetOfBytes && Arrays.equals(this.bits, ((SetOfBytes)other).bits);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bits);
    }

    public int size() {
        int n = 0;
        for (int b = 0; b < 256; ++b) {
            if (!this.bits[b]) continue;
            ++n;
        }
        return n;
    }

    public byte[] getBytes() {
        byte[] out = new byte[this.size()];
        int i = 0;
        for (int b = 0; b < 256; ++b) {
            if (!this.bits[b]) continue;
            out[i++] = (byte)b;
        }
        return out;
    }

    public String toString() {
        return "SetOfBytes(" + Arrays.toString(this.getBytes()) + ")";
    }
}

