/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class BinaryFileTransfer {
    public static byte[] convertStringToByteArr(String s) {
        if (s.length() % 2 != 0) {
            throw new RuntimeException("String length must be even (was " + s.length() + ")");
        }
        ArrayList<Byte> byteArrayList = new ArrayList<Byte>();
        for (int i = 0; i < s.length(); i += 2) {
            String s2 = s.substring(i, i + 2);
            Integer i2 = Integer.parseInt(s2, 16);
            Byte b2 = (byte)(i2 & 0xFF);
            byteArrayList.add(b2);
        }
        byte[] byteArr = new byte[byteArrayList.size()];
        for (int i = 0; i < byteArr.length; ++i) {
            byteArr[i] = (Byte)byteArrayList.get(i);
        }
        return byteArr;
    }

    public static void writeBinaryFile(String fileName, byte[] byteArr) throws IOException {
        FileOutputStream out = new FileOutputStream(fileName);
        for (byte b : byteArr) {
            out.write(b);
        }
        out.close();
    }

    public static String convertByteArrToString(byte[] byteArr) {
        StringBuilder sb = new StringBuilder();
        byte[] byArray = byteArr;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            int b;
            int i2 = b = byArray[i];
            sb.append(String.format("%02x", i2 &= 0xFF));
        }
        return sb.toString();
    }
}

