/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.string;

import java.util.ArrayList;
import java.util.HashMap;
import water.MRTask;
import water.fvec.C0DChunk;
import water.fvec.CStrChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.ast.params.AstNumList;
import water.rapids.vals.ValFrame;
import water.util.VecUtils;

public class AstSubstring
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "startIndex", "endIndex"};
    }

    @Override
    public int nargs() {
        return 4;
    }

    @Override
    public String str() {
        return "substring";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        int startIndex = (int)asts[2].exec(env).getNum();
        if (startIndex < 0) {
            startIndex = 0;
        }
        int endIndex = asts[3] instanceof AstNumList ? Integer.MAX_VALUE : (int)asts[3].exec(env).getNum();
        for (Vec v : fr.vecs()) {
            if (v.isCategorical() || v.isString()) continue;
            throw new IllegalArgumentException("substring() requires a string or categorical column. Received " + fr.anyVec().get_type_str() + ". Please convert column to a string or categorical first.");
        }
        Vec[] nvs = new Vec[fr.numCols()];
        int i = 0;
        for (Vec v : fr.vecs()) {
            nvs[i] = v.isCategorical() ? this.substringCategoricalCol(v, startIndex, endIndex) : this.substringStringCol(v, startIndex, endIndex);
            ++i;
        }
        return new ValFrame(new Frame(nvs));
    }

    private Vec substringCategoricalCol(Vec vec, int startIndex, int endIndex) {
        if (startIndex >= endIndex) {
            Vec v = Vec.makeZero(vec.length());
            v.setDomain(new String[]{""});
            return v;
        }
        String[] dom = (String[])vec.domain().clone();
        HashMap<String, ArrayList<Integer>> substringToOldDomainIndices = new HashMap<String, ArrayList<Integer>>();
        for (int i = 0; i < dom.length; ++i) {
            String substr;
            dom[i] = substr = dom[i].substring(startIndex < dom[i].length() ? startIndex : dom[i].length(), endIndex < dom[i].length() ? endIndex : dom[i].length());
            if (!substringToOldDomainIndices.containsKey(substr)) {
                ArrayList<Integer> val = new ArrayList<Integer>();
                val.add(i);
                substringToOldDomainIndices.put(substr, val);
                continue;
            }
            substringToOldDomainIndices.get(substr).add(i);
        }
        if (substringToOldDomainIndices.size() < dom.length) {
            return VecUtils.DomainDedupe.domainDeduper(vec, substringToOldDomainIndices);
        }
        return vec.makeCopy(dom);
    }

    private Vec substringStringCol(Vec vec, final int startIndex, final int endIndex) {
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                if (chk instanceof C0DChunk) {
                    for (int i = 0; i < chk.len(); ++i) {
                        newChk.addNA();
                    }
                } else if (startIndex >= endIndex) {
                    for (int i = 0; i < chk.len(); ++i) {
                        newChk.addStr("");
                    }
                } else if (((CStrChunk)chk)._isAllASCII) {
                    ((CStrChunk)chk).asciiSubstring(newChk, startIndex, endIndex);
                } else {
                    BufferedString tmpStr = new BufferedString();
                    for (int i = 0; i < chk._len; ++i) {
                        String str;
                        if (chk.isNA(i)) {
                            newChk.addNA();
                            continue;
                        }
                        newChk.addStr(str.substring(startIndex < (str = chk.atStr(tmpStr, i).toString()).length() ? startIndex : str.length(), endIndex < str.length() ? endIndex : str.length()));
                    }
                }
            }
        }.doAll(new byte[]{2}, vec)).outputFrame().anyVec();
    }
}

