/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.mungers;

import water.Futures;
import water.Key;
import water.fvec.AppendableVec;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstLevels
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "levels";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame f = stk.track(asts[1].exec(env)).getFrame();
        Futures fs = new Futures();
        Key<Vec>[] keys = Vec.VectorGroup.VG_LEN1.addVecs(f.numCols());
        Vec[] vecs = new Vec[keys.length];
        int max = 0;
        for (int i = 0; i < f.numCols(); ++i) {
            if (!f.vec(i).isCategorical() || max >= f.vec(i).domain().length) continue;
            max = f.vec(i).domain().length;
        }
        int rowLayout = Vec.ESPC.rowLayout(keys[0], new long[]{0L, max});
        for (int i = 0; i < f.numCols(); ++i) {
            int j;
            int numToPad;
            AppendableVec v = new AppendableVec(keys[i], 3);
            NewChunk nc = new NewChunk(v, 0);
            String[] dom = f.vec(i).domain();
            int n = numToPad = dom == null ? max : max - dom.length;
            if (dom != null) {
                for (j = 0; j < dom.length; ++j) {
                    nc.addNum(j);
                }
            }
            for (j = 0; j < numToPad; ++j) {
                nc.addNA();
            }
            nc.close(0, fs);
            vecs[i] = v.close(rowLayout, fs);
            vecs[i].setDomain(dom);
        }
        fs.blockForPending();
        Frame fr2 = new Frame(vecs);
        return new ValFrame(fr2);
    }
}

