/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.mungers;

import water.H2O;
import water.fvec.Frame;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;
import water.rapids.vals.ValNum;
import water.rapids.vals.ValStr;

public class AstFlatten
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "flatten";
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        if (fr.numCols() != 1 || fr.numRows() != 1L) {
            return new ValFrame(fr);
        }
        Vec vec = fr.anyVec();
        switch (vec.get_type()) {
            case 0: 
            case 3: {
                return new ValNum(vec.at(0L));
            }
            case 5: {
                return vec.isNA(0L) ? new ValNum(Double.NaN) : new ValNum(vec.at8(0L));
            }
            case 2: {
                return vec.isNA(0L) ? new ValStr("NA") : new ValStr(vec.atStr(new BufferedString(), 0L).toString());
            }
            case 4: {
                return vec.isNA(0L) ? new ValStr("NA") : new ValStr(vec.factor(vec.at8(0L)));
            }
        }
        throw H2O.unimpl("The type of vector: " + vec.get_type_str() + " is not supported by " + this.str());
    }
}

