/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.advmath;

import water.DKV;
import water.H2O;
import water.fvec.Frame;
import water.fvec.Vec;
import water.fvec.task.UniqOldTask;
import water.fvec.task.UniqTask;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;
import water.util.Log;
import water.util.VecUtils;

public class AstUnique
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "unique";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        boolean includeNAs = asts[2].exec(env).getBool();
        return new ValFrame(AstUnique.uniqueValuesBy(fr, 0, includeNAs));
    }

    public static Frame uniqueValuesBy(Frame fr, int columnIndex, boolean includeNAs) {
        Vec v;
        Vec vec0 = fr.vec(columnIndex);
        if (vec0.isCategorical()) {
            String[] actualVecDomain = VecUtils.collectDomainFast(vec0);
            boolean contributeNAs = vec0.naCnt() > 0L && includeNAs;
            long uniqueVecLength = contributeNAs ? (long)(actualVecDomain.length + 1) : (long)actualVecDomain.length;
            v = Vec.makeSeq(0L, uniqueVecLength, true);
            if (contributeNAs) {
                v.setNA(uniqueVecLength - 1L);
            }
            v.setDomain(actualVecDomain);
            DKV.put(v);
        } else {
            String uniqImpl;
            long start = System.currentTimeMillis();
            switch (uniqImpl = H2O.getSysProperty("rapids.unique.impl", "IcedDouble")) {
                case "IcedDouble": {
                    v = ((UniqTask)new UniqTask().doAll(vec0)).toVec();
                    break;
                }
                case "GroupBy": {
                    v = ((UniqOldTask)new UniqOldTask().doAll(vec0)).toVec();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown unique implementation: " + uniqImpl);
                }
            }
            Log.info("Unique on a numerical Vec (len=" + vec0.length() + ") took " + (System.currentTimeMillis() - start) + "ms and returned " + v.length() + " unique values (impl: " + uniqImpl + ").");
        }
        return new Frame(v);
    }
}

