/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import water.Job;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.parser.ParseFinalizer;
import water.parser.ParseSetup;

public class SyntheticColumnGenerator
extends ParseFinalizer {
    @Override
    public Frame finalize(Job<Frame> job, Vec[] parsedVecs, ParseSetup setup, int[] fileChunkOffsets) {
        int synthIdx;
        Vec[] withSynth = new Vec[parsedVecs.length + setup._synthetic_column_names.length];
        System.arraycopy(parsedVecs, 0, withSynth, 0, parsedVecs.length);
        for (synthIdx = 0; synthIdx < setup._synthetic_column_names.length; ++synthIdx) {
            withSynth[parsedVecs.length + synthIdx] = parsedVecs[0].makeCon((byte)2);
        }
        new SyntheticColumnGeneratorTask(setup, fileChunkOffsets).doAll(withSynth);
        if (4 == setup._synthetic_column_type) {
            for (synthIdx = 0; synthIdx < setup._synthetic_column_names.length; ++synthIdx) {
                Vec originalSyntheticVec = withSynth[parsedVecs.length + synthIdx];
                withSynth[parsedVecs.length + synthIdx] = withSynth[parsedVecs.length + synthIdx].toCategoricalVec();
                originalSyntheticVec.remove();
            }
        }
        return new Frame(job._result, this.mergeColumnNames(setup), withSynth);
    }

    private String[] mergeColumnNames(ParseSetup parseSetup) {
        String[] names = new String[parseSetup._column_names.length + parseSetup._synthetic_column_names.length];
        System.arraycopy(parseSetup._column_names, 0, names, 0, parseSetup._column_names.length);
        System.arraycopy(parseSetup._synthetic_column_names, 0, names, parseSetup._column_names.length, parseSetup._synthetic_column_names.length);
        return names;
    }

    static class SyntheticColumnGeneratorTask
    extends MRTask<SyntheticColumnGeneratorTask> {
        private final ParseSetup _setup;
        private final int[] _fileChunkOffsets;

        SyntheticColumnGeneratorTask(ParseSetup setup, int[] fileChunkOffsets) {
            this._setup = setup;
            this._fileChunkOffsets = fileChunkOffsets;
        }

        @Override
        public void map(Chunk[] cs) {
            int synColCnt = this._setup._synthetic_column_names.length;
            for (int colIdx = 0; colIdx < synColCnt; ++colIdx) {
                int fileIdx = this.findFileIndexForChunk(cs[0].cidx());
                String colValue = this._setup._synthetic_column_values[fileIdx][colIdx];
                for (int row = 0; row < cs[0]._len; ++row) {
                    cs[cs.length - synColCnt + colIdx].set(row, colValue);
                }
            }
        }

        private int findFileIndexForChunk(int cidx) {
            for (int i = 0; i < this._fileChunkOffsets.length; ++i) {
                if (this._fileChunkOffsets[i] > cidx || i + 1 != this._fileChunkOffsets.length && this._fileChunkOffsets[i + 1] <= cidx) continue;
                return i;
            }
            throw new RuntimeException("Failed to find file for chunk index " + cidx);
        }
    }
}

