/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.util.Arrays;
import java.util.Formatter;
import water.AutoBuffer;
import water.Iced;
import water.util.StringUtils;

public class BufferedString
extends Iced
implements Comparable<BufferedString> {
    protected byte[] _buf;
    protected int _off;
    protected int _len;
    public static final byte NA = 0;
    public static final byte INT = 1;
    public static final byte REAL = 2;

    public BufferedString(byte[] buf, int off, int len) {
        this._buf = buf;
        this._off = off;
        this._len = len;
        assert (len >= 0) : "Bad length in constructor " + len;
    }

    private BufferedString(byte[] buf) {
        this(buf, 0, buf.length);
    }

    BufferedString(BufferedString from) {
        this(Arrays.copyOfRange(from._buf, from._off, from._off + from._len));
    }

    public BufferedString(String from) {
        this(StringUtils.bytesOf(from));
    }

    public BufferedString() {
    }

    public final AutoBuffer write_impl(AutoBuffer ab) {
        if (this._buf == null) {
            return ab.putInt(-1);
        }
        ab.putInt(this._len);
        return ab.putA1(this._buf, this._off, this._off + this._len);
    }

    public final BufferedString read_impl(AutoBuffer ab) {
        this._buf = ab.getA1();
        if (this._buf != null) {
            this._len = this._buf.length;
        }
        return this;
    }

    @Override
    public int compareTo(BufferedString o) {
        int len = Math.min(this._len, o._len);
        for (int i = 0; i < len; ++i) {
            int x = (0xFF & this._buf[this._off + i]) - (0xFF & o._buf[o._off + i]);
            if (x == 0) continue;
            return x;
        }
        return this._len - o._len;
    }

    public int hashCode() {
        int hash = 0;
        int n = this._off + this._len;
        for (int i = this._off; i < n; ++i) {
            hash = 31 * hash + (char)this._buf[i];
        }
        return hash;
    }

    void addChar() {
        ++this._len;
    }

    void removeChar() {
        --this._len;
    }

    void addBuff(byte[] bits) {
        byte[] buf = new byte[this._len];
        int l1 = this._buf.length - this._off;
        System.arraycopy(this._buf, this._off, buf, 0, l1);
        System.arraycopy(bits, 0, buf, l1, this._len - l1);
        this._off = 0;
        this._buf = buf;
    }

    public String toString() {
        return this._buf == null ? null : StringUtils.toString(this._buf, Math.max(0, this._off), Math.min(this._buf.length, this._len));
    }

    public String toSanitizedString() {
        StringBuilder sb = new StringBuilder(this._len * 2);
        Formatter formatter = new Formatter(sb);
        boolean inHex = false;
        for (int i = 0; i < this._len; ++i) {
            if ((this._buf[this._off + i] & 0x80) == 128) {
                if (!inHex) {
                    sb.append("<0x");
                }
                formatter.format("%02X", this._buf[this._off + i]);
                inHex = true;
                continue;
            }
            if (inHex) {
                sb.append(">");
                inHex = false;
            }
            formatter.format("%c", this._buf[this._off + i]);
        }
        if (inHex) {
            sb.append(">");
        }
        return sb.toString();
    }

    public static String[] toString(BufferedString[] bStr) {
        if (bStr == null) {
            return null;
        }
        String[] ss = new String[bStr.length];
        for (int i = 0; i < bStr.length; ++i) {
            ss[i] = bStr[i].toString();
        }
        return ss;
    }

    public static BufferedString[] toBufferedString(String[] strings) {
        if (strings == null) {
            return null;
        }
        BufferedString[] res = new BufferedString[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            res[i] = new BufferedString(strings[i]);
        }
        return res;
    }

    public final BufferedString set(byte[] buf) {
        return this.set(buf, 0, buf.length);
    }

    public BufferedString set(byte[] buf, int off, int len) {
        this._buf = buf;
        this._off = off;
        this._len = len;
        assert (len >= 0) : "Bad length in setter " + len;
        return this;
    }

    public final BufferedString set(String s) {
        return this.set(StringUtils.bytesOf(s));
    }

    public void setOff(int off) {
        this._off = off;
    }

    public void setLen(int len) {
        this._len = len;
    }

    public boolean equals(Object o) {
        if (o instanceof BufferedString) {
            BufferedString str = (BufferedString)o;
            if (str._len != this._len) {
                return false;
            }
            for (int i = 0; i < this._len; ++i) {
                if (this._buf[this._off + i] == str._buf[str._off + i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equalsAsciiString(String str) {
        if (str == null || str.length() != this._len) {
            return false;
        }
        for (int i = 0; i < this._len; ++i) {
            if (this._buf[this._off + i] == str.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public final byte[] getBuffer() {
        return this._buf;
    }

    public final int getOffset() {
        return this._off;
    }

    public final int length() {
        return this._len;
    }

    public final byte getNumericType() {
        int i = 0;
        int decimalCnt = 0;
        if (this._len == 0) {
            return 0;
        }
        if (this._buf[this._off] == 43 || this._buf[this._off] == 45) {
            ++i;
        }
        while (i < this._len) {
            if (this._buf[this._off + i] == 46) {
                ++decimalCnt;
            } else if (this._buf[this._off + i] < 48 || this._buf[this._off + i] > 57) {
                return 0;
            }
            ++i;
        }
        if (decimalCnt > 0) {
            if (decimalCnt == 1) {
                return 2;
            }
            return 0;
        }
        return 1;
    }
}

