/*
 * Decompiled with CFR 0.152.
 */
package water.init;

import water.H2ORuntime;
import water.MemoryManager;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.Timer;

public class MemoryBandwidth {
    public static void main(String[] args) {
        int num_threads = H2ORuntime.availableProcessors();
        double membw = MemoryBandwidth.run(num_threads);
        Log.info("Memory bandwidth (" + num_threads + " cores) : " + membw + " GB/s.");
    }

    public static double run(int num_threads) {
        int t;
        final double[] membw = new double[num_threads];
        Thread[] threads = new Thread[num_threads];
        for (t = 0; t < num_threads; ++t) {
            final int thread_num = t;
            threads[t] = new Thread(){

                @Override
                public void run() {
                    MemoryBandwidth l = new MemoryBandwidth();
                    membw[thread_num] = l.run_benchmark();
                }
            };
        }
        for (t = 0; t < num_threads; ++t) {
            threads[t].start();
        }
        for (t = 0; t < num_threads; ++t) {
            try {
                threads[t].join();
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return ArrayUtils.sum(membw);
    }

    double run_benchmark() {
        long M = Math.min(10000000L, Runtime.getRuntime().maxMemory() / 10L);
        int[] vals = MemoryManager.malloc4((int)M);
        int repeats = 20;
        Timer timer = new Timer();
        long sum = 0L;
        for (int l = repeats - 1; l >= 0; --l) {
            int i = 0;
            while ((long)i < M) {
                vals[i] = i + l;
                ++i;
            }
            sum = 0L;
            i = 0;
            while ((long)i < M) {
                sum += (long)vals[i];
                ++i;
            }
        }
        double total = (double)timer.time() / 1000.0 / (double)repeats;
        double time = total + (double)(M * (M - 1L) / 2L - sum);
        return 2.0 * (double)M * 4.0 / time;
    }
}

