/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.fvec.CSChunk;
import water.fvec.ChunkVisitor;
import water.util.PrettyPrint;
import water.util.UnsafeUtils;

public class C4SChunk
extends CSChunk {
    C4SChunk(byte[] bs, long bias, int scale) {
        super(bs, bias, scale, 2);
        if (scale < 0) {
            double div = PrettyPrint.pow10(1L, -scale);
            for (int i = 0; i < this._len; ++i) {
                int x = this.getMantissa(i);
                if (x == Integer.MIN_VALUE || this.getD(x, 255, Double.NaN) == (double)((long)x + bias) / div) continue;
                this.setDecimal();
                break;
            }
        }
    }

    private int getMantissa(int i) {
        return UnsafeUtils.get4(this._mem, 16 + 4 * i);
    }

    private void setMantissa(int i, int j) {
        UnsafeUtils.set4(this._mem, i * 4 + 16, j);
    }

    @Override
    protected final double atd_impl(int i) {
        return this.getD(this.getMantissa(i), Integer.MIN_VALUE);
    }

    @Override
    protected final boolean isNA_impl(int i) {
        return this.getMantissa(i) == Integer.MIN_VALUE;
    }

    @Override
    boolean set_impl(int i, double x) {
        if (Double.isNaN(x)) {
            return this.setNA_impl(i);
        }
        int y = this.getScaledValue(x, Integer.MIN_VALUE);
        if (this.getD(y, Integer.MIN_VALUE, Double.NaN) != x) {
            return false;
        }
        this.setMantissa(i, y);
        assert (!this.isNA_impl(i));
        return true;
    }

    @Override
    boolean setNA_impl(int idx) {
        this.setMantissa(idx, Integer.MIN_VALUE);
        return true;
    }

    @Override
    public double[] getDoubles(double[] vals, int from, int to, double NA) {
        for (int i = from; i < to; ++i) {
            vals[i - from] = this.getD(this.getMantissa(i), Integer.MIN_VALUE, NA);
        }
        return vals;
    }

    @Override
    public double[] getDoubles(double[] vals, int[] ids) {
        int k = 0;
        for (int i : ids) {
            vals[k++] = this.getD(this.getMantissa(i), Integer.MIN_VALUE);
        }
        return vals;
    }

    private <T extends ChunkVisitor> void processRow(T v, int i, long bias, int exp) {
        long x = this.getMantissa(i);
        if (x == Integer.MIN_VALUE) {
            v.addNAs(1);
        } else {
            v.addValue(x + bias, exp);
        }
    }

    @Override
    protected <T extends ChunkVisitor> T processRows2(T v, int from, int to, long bias, int exp) {
        for (int i = from; i < to; ++i) {
            this.processRow(v, i, bias, exp);
        }
        return v;
    }

    @Override
    protected <T extends ChunkVisitor> T processRows2(T v, int from, int to) {
        for (int i = from; i < to; ++i) {
            v.addValue(this.getD(this.getMantissa(i), Integer.MIN_VALUE));
        }
        return v;
    }

    @Override
    protected <T extends ChunkVisitor> T processRows2(T v, int[] ids, long bias, int exp) {
        for (int i : ids) {
            this.processRow(v, i, bias, exp);
        }
        return v;
    }

    @Override
    protected <T extends ChunkVisitor> T processRows2(T v, int[] ids) {
        for (int i : ids) {
            v.addValue(this.getD(this.getMantissa(i), Integer.MIN_VALUE));
        }
        return v;
    }
}

