/*
 * Decompiled with CFR 0.152.
 */
package water.api.schemas3;

import hex.ModelMetricsMultinomial;
import hex.ModelMetricsSupervised;
import water.Iced;
import water.api.API;
import water.api.SchemaServer;
import water.api.schemas3.ConfusionMatrixV3;
import water.api.schemas3.ModelMetricsBaseV3;
import water.api.schemas3.TwoDimTableV3;
import water.util.TwoDimTable;

public class ModelMetricsMultinomialV3<I extends ModelMetricsMultinomial, S extends ModelMetricsMultinomialV3<I, S>>
extends ModelMetricsBaseV3<I, S> {
    @API(help="The R^2 for this scoring run.", direction=API.Direction.OUTPUT)
    public double r2;
    @API(help="The hit ratio table for this scoring run.", direction=API.Direction.OUTPUT, level=API.Level.expert)
    public TwoDimTableV3 hit_ratio_table;
    @API(help="The ConfusionMatrix object for this scoring run.", direction=API.Direction.OUTPUT)
    public ConfusionMatrixV3 cm;
    @API(help="The logarithmic loss for this scoring run.", direction=API.Direction.OUTPUT)
    public double logloss;
    @API(help="The mean misclassification error per class.", direction=API.Direction.OUTPUT)
    public double mean_per_class_error;
    @API(help="The average AUC for this scoring run.", direction=API.Direction.OUTPUT)
    public double AUC;
    @API(help="The average precision-recall AUC for this scoring run.", direction=API.Direction.OUTPUT)
    public double pr_auc;
    @API(help="The multinomial AUC values.", direction=API.Direction.OUTPUT, level=API.Level.expert)
    public TwoDimTableV3 multinomial_auc_table;
    @API(help="The multinomial PR AUC values.", direction=API.Direction.OUTPUT, level=API.Level.expert)
    public TwoDimTableV3 multinomial_aucpr_table;

    @Override
    public S fillFromImpl(I modelMetrics) {
        super.fillFromImpl((Iced)modelMetrics);
        this.logloss = ((ModelMetricsMultinomial)modelMetrics).logloss();
        this.r2 = ((ModelMetricsSupervised)modelMetrics).r2();
        if (((ModelMetricsMultinomial)modelMetrics)._hit_ratios != null) {
            TwoDimTable table = ModelMetricsMultinomial.getHitRatioTable(((ModelMetricsMultinomial)modelMetrics)._hit_ratios);
            this.hit_ratio_table = (TwoDimTableV3)SchemaServer.schema(this.getSchemaVersion(), table).fillFromImpl(table);
        }
        this.AUC = ((ModelMetricsMultinomial)modelMetrics).auc();
        this.pr_auc = ((ModelMetricsMultinomial)modelMetrics).pr_auc();
        if (((ModelMetricsMultinomial)modelMetrics)._auc != null && ((ModelMetricsMultinomial)modelMetrics)._auc._calculateAuc) {
            TwoDimTable aucTable = ((ModelMetricsMultinomial)modelMetrics)._auc.getTable(false);
            this.multinomial_auc_table = (TwoDimTableV3)SchemaServer.schema(this.getSchemaVersion(), aucTable).fillFromImpl(aucTable);
            TwoDimTable aucprTable = ((ModelMetricsMultinomial)modelMetrics)._auc.getTable(true);
            this.multinomial_aucpr_table = (TwoDimTableV3)SchemaServer.schema(this.getSchemaVersion(), aucprTable).fillFromImpl(aucprTable);
        }
        if (null != ((ModelMetricsMultinomial)modelMetrics)._cm) {
            ((ModelMetricsMultinomial)modelMetrics)._cm.table();
            this.cm = (ConfusionMatrixV3)SchemaServer.schema(this.getSchemaVersion(), ((ModelMetricsMultinomial)modelMetrics)._cm).fillFromImpl(((ModelMetricsMultinomial)modelMetrics)._cm);
        }
        return (S)this;
    }
}

