/*
 * Decompiled with CFR 0.152.
 */
package water;

import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Key;
import water.Value;
import water.api.schemas3.KeyV3;
import water.util.Log;

public abstract class Keyed<T extends Keyed>
extends Iced<T> {
    public Key<T> _key;
    private long _checksum;

    public Keyed() {
        this._key = null;
    }

    public Keyed(Key<T> key) {
        this._key = key;
    }

    public Key<T> getKey() {
        return this._key;
    }

    public final void remove() {
        this.remove(true);
    }

    public final void remove(boolean cascade) {
        this.remove(new Futures(), cascade).blockForPending();
    }

    public final Futures remove(Futures fs) {
        return this.remove(fs, true);
    }

    public final Futures remove(Futures fs, boolean cascade) {
        fs = this.remove_self_key_impl(fs);
        return this.remove_impl(fs, cascade);
    }

    @Deprecated
    protected Futures remove_impl(Futures fs) {
        return fs;
    }

    protected Futures remove_impl(Futures fs, boolean cascade) {
        return this.remove_impl(fs);
    }

    protected Futures remove_self_key_impl(Futures fs) {
        if (this._key != null) {
            DKV.remove(this._key, fs);
        }
        return fs;
    }

    public static void remove(Key k) {
        if (k == null) {
            return;
        }
        Value val = DKV.get(k);
        if (val == null) {
            return;
        }
        ((Keyed)val.get()).remove();
    }

    public static void removeQuietly(Key k) {
        try {
            Keyed.remove(k);
        }
        catch (Exception e) {
            String reason = e.getMessage() != null ? " Reason: " + e.getMessage() : "";
            Log.warn("Failed to correctly release memory associated with key=" + k + "." + reason);
            Log.debug("Failed to remove key " + k, e);
        }
    }

    public static Futures remove(Key k, Futures fs, boolean cascade) {
        if (k == null) {
            return fs;
        }
        Value val = DKV.get(k);
        if (val == null) {
            return fs;
        }
        return ((Keyed)val.get()).remove(fs, cascade);
    }

    public AutoBuffer writeAll(AutoBuffer ab) {
        return this.writeAll_impl(ab.put(this));
    }

    protected AutoBuffer writeAll_impl(AutoBuffer ab) {
        return ab;
    }

    public static Keyed readAll(AutoBuffer ab) {
        Futures fs = new Futures();
        Keyed k = ab.getKey(fs);
        fs.blockForPending();
        return k;
    }

    protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
        return this;
    }

    protected long checksum_impl() {
        throw H2O.fail("Checksum not implemented by class " + this.getClass());
    }

    protected long checksum_impl(boolean noCache) {
        return this.checksum_impl();
    }

    public final long checksum() {
        if (this._checksum != 0L) {
            return this._checksum;
        }
        long x = this.checksum_impl(false);
        if (x == 0L) {
            x = 1L;
        }
        this._checksum = x;
        return this._checksum;
    }

    public final long checksum(boolean noCache) {
        if (noCache) {
            return this.checksum_impl(noCache);
        }
        return this.checksum();
    }

    public Class<? extends KeyV3> makeSchema() {
        throw H2O.fail("Override in subclasses which can be the result of a Job");
    }
}

