/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import water.DKV;
import water.Futures;
import water.H2O;
import water.H2ONode;
import water.Key;
import water.Keyed;
import water.Value;
import water.fvec.Frame;
import water.fvec.Vec;

public class DKVManager {
    public static void retain(Key ... retainedKeys) {
        HashSet<Key> retainedSet = new HashSet<Key>(retainedKeys.length);
        retainedSet.addAll(Arrays.asList(retainedKeys));
        DKVManager.extractNestedKeys(retainedSet);
        Key[] allRetainedkeys = retainedSet.toArray(new Key[retainedSet.size()]);
        NodeKeysRemovalTask nodeKeysRemovalTask = new NodeKeysRemovalTask(allRetainedkeys);
        for (H2ONode node : H2O.CLOUD.members()) {
            H2O.runOnH2ONode(node, nodeKeysRemovalTask);
        }
    }

    private static void extractNestedKeys(Set<Key> retainedKeys) throws IllegalArgumentException {
        Iterator<Key> keysIterator = retainedKeys.iterator();
        HashSet<Key> newKeys = new HashSet<Key>();
        while (keysIterator.hasNext()) {
            Key key = keysIterator.next();
            Value value = DKV.get(key);
            if (value == null || value.isNull()) continue;
            if (!value.isFrame() && !value.isModel()) {
                throw new IllegalArgumentException(String.format("Given key %s is of type %d. Please provide only Model and Frame keys.", key.toString(), value.type()));
            }
            if (!value.isFrame()) continue;
            DKVManager.extractFrameKeys(newKeys, (Frame)value.get());
        }
        retainedKeys.addAll(newKeys);
    }

    private static void extractFrameKeys(Set<Key> retainedkeys, Frame frame) {
        Key<Vec>[] frameKeys;
        Objects.requireNonNull(frame);
        for (Key<Vec> k : frameKeys = frame.keys()) {
            retainedkeys.add(k);
        }
    }

    private static final class NodeKeysRemovalTask
    extends H2O.RemoteRunnable<NodeKeysRemovalTask> {
        private final Key[] _ignoredKeys;

        private NodeKeysRemovalTask(Key[] retainedKeys) {
            this._ignoredKeys = retainedKeys;
        }

        @Override
        public void run() {
            Set<Key> keys = H2O.localKeySet();
            HashSet<Key> ignoredSet = new HashSet<Key>();
            Futures futures = new Futures();
            for (Key ignoredKey : this._ignoredKeys) {
                ignoredSet.add(ignoredKey);
            }
            for (Key key : keys) {
                Value value;
                if (ignoredSet.contains(key) || (value = DKV.get(key)) == null || value.isNull()) continue;
                if (value.isModel()) {
                    Keyed.remove(key, futures, false);
                } else if (value.isFrame()) {
                    Frame frame = (Frame)value.get();
                    frame.retain(futures, ignoredSet);
                }
                futures.blockForPending();
            }
        }
    }
}

