/*
 * Decompiled with CFR 0.152.
 */
package hex.segments;

import hex.Model;
import hex.ModelBuilder;
import hex.segments.SegmentModels;
import hex.segments.SegmentModelsStats;
import hex.segments.SegmentModelsUtils;
import hex.segments.WorkAllocator;
import java.util.Arrays;
import water.Futures;
import water.Iced;
import water.Job;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.util.Log;

class LocalSequentialSegmentModelsBuilder
extends Iced<LocalSequentialSegmentModelsBuilder> {
    private final Job<SegmentModels> _job;
    private final Model.Parameters _blueprint_parms;
    private final Frame _segments;
    private final Frame _full_train;
    private final Frame _full_valid;
    private final WorkAllocator _allocator;

    LocalSequentialSegmentModelsBuilder(Job<SegmentModels> job, Model.Parameters blueprint_parms, Frame segments, Frame fullTrain, Frame fullValid, WorkAllocator allocator) {
        this._job = job;
        this._blueprint_parms = blueprint_parms;
        this._segments = segments;
        this._full_train = fullTrain;
        this._full_valid = fullValid;
        this._allocator = allocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SegmentModelsStats buildModels(SegmentModels segmentModels) {
        Vec.Reader[] segmentVecReaders = new Vec.Reader[this._segments.numCols()];
        for (int i = 0; i < segmentVecReaders.length; ++i) {
            segmentVecReaders[i] = new Vec.Reader(this._segments.vec(i));
        }
        SegmentModelsStats stats = new SegmentModelsStats();
        long segmentIdx = this._allocator.getNextWorkItem();
        while (segmentIdx < this._allocator.getMaxWork()) {
            SegmentModels.SegmentModelResult result;
            if (this._job.stop_requested()) {
                throw new Job.JobCancelledException();
            }
            double[] segmentVals = LocalSequentialSegmentModelsBuilder.readRow(segmentVecReaders, segmentIdx);
            ModelBuilder builder = this.makeBuilder(segmentIdx, segmentVals);
            Exception failure = null;
            try {
                builder.init(false);
                if (builder.error_count() == 0) {
                    builder.trainModel().get();
                }
                this._job.update(1L);
                result = segmentModels.addResult(segmentIdx, builder, failure);
            }
            catch (Exception e) {
                try {
                    failure = e;
                    this._job.update(1L);
                    result = segmentModels.addResult(segmentIdx, builder, failure);
                }
                catch (Throwable throwable) {
                    this._job.update(1L);
                    SegmentModels.SegmentModelResult result2 = segmentModels.addResult(segmentIdx, builder, failure);
                    Log.info("Finished building a model for segment id=", segmentIdx, ", result: ", result2);
                    this.cleanUp(builder);
                    if (result2.isSuccessful()) {
                        ++stats._succeeded;
                    } else {
                        ++stats._failed;
                    }
                    throw throwable;
                }
                Log.info("Finished building a model for segment id=", segmentIdx, ", result: ", result);
                this.cleanUp(builder);
                if (result.isSuccessful()) {
                    ++stats._succeeded;
                } else {
                    ++stats._failed;
                }
            }
            Log.info("Finished building a model for segment id=", segmentIdx, ", result: ", result);
            this.cleanUp(builder);
            if (result.isSuccessful()) {
                ++stats._succeeded;
            } else {
                ++stats._failed;
            }
            segmentIdx = this._allocator.getNextWorkItem();
        }
        return stats;
    }

    private void cleanUp(ModelBuilder builder) {
        Futures fs = new Futures();
        Keyed.remove(((Model.Parameters)builder._parms)._train, fs, true);
        Keyed.remove(((Model.Parameters)builder._parms)._valid, fs, true);
        fs.blockForPending();
    }

    private ModelBuilder makeBuilder(long segmentIdx, double[] segmentVals) {
        Key<Model> mKey = SegmentModelsUtils.makeUniqueModelKey(this._job._result, segmentIdx);
        Object builder = ModelBuilder.make(this._blueprint_parms, mKey);
        ((Model.Parameters)((ModelBuilder)builder)._parms)._train = this.makeSegmentFrame(this._full_train, segmentIdx, segmentVals);
        ((Model.Parameters)((ModelBuilder)builder)._parms)._valid = this.makeSegmentFrame(this._full_valid, segmentIdx, segmentVals);
        return builder;
    }

    private Key<Frame> makeSegmentFrame(Frame f, long segmentIdx, double[] segmentVals) {
        if (f == null) {
            return null;
        }
        Key<Frame> segmentFrameKey = Key.make(f.toString() + "_segment_" + segmentIdx);
        Frame segmentFrame = ((MakeSegmentFrame)new MakeSegmentFrame(segmentVals).doAll(f.types(), f)).outputFrame(segmentFrameKey, f.names(), f.domains());
        assert (segmentFrameKey.equals(segmentFrame._key));
        return segmentFrameKey;
    }

    private static double[] readRow(Vec.Reader[] vecReaders, long r) {
        double[] row = new double[vecReaders.length];
        for (int i = 0; i < row.length; ++i) {
            row[i] = vecReaders[i].isNA(r) ? Double.NaN : vecReaders[i].at(r);
        }
        return row;
    }

    private static class MakeSegmentFrame
    extends MRTask<MakeSegmentFrame> {
        private final double[] _match_row;

        MakeSegmentFrame(double[] matchRow) {
            this._match_row = matchRow;
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] ncs) {
            int cnt = 0;
            int[] rows = new int[cs[0]._len];
            block0: for (int row = 0; row < rows.length; ++row) {
                for (int i = 0; i < this._match_row.length; ++i) {
                    if (Double.isNaN(this._match_row[i]) && !cs[i].isNA(row) || this._match_row[i] != cs[i].atd(row)) continue block0;
                }
                rows[cnt++] = row;
            }
            if (cnt == 0) {
                return;
            }
            rows = cnt == rows.length ? rows : Arrays.copyOf(rows, cnt);
            for (int i = 0; i < cs.length; ++i) {
                cs[i].extractRows(ncs[i], rows);
            }
        }
    }
}

