/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.types;

import java.util.function.Consumer;
import org.tensorflow.SparseTensor;
import org.tensorflow.Tensor;
import org.tensorflow.internal.types.TUint16Mapper;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.ShortNdArray;
import org.tensorflow.ndarray.StdArrays;
import org.tensorflow.ndarray.buffer.ShortDataBuffer;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.annotation.TensorType;
import org.tensorflow.types.family.TIntegral;

@TensorType(dataType=DataType.DT_UINT16, byteSize=2, mapperClass=TUint16Mapper.class)
public interface TUint16
extends ShortNdArray,
TIntegral {
    public static TUint16 scalarOf(short value) {
        return Tensor.of(TUint16.class, Shape.scalar(), (T data) -> data.setShort(value, new long[0]));
    }

    public static TUint16 vectorOf(short ... values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        return Tensor.of(TUint16.class, Shape.of(values.length), (T data) -> StdArrays.copyTo(values, (ShortNdArray)data));
    }

    public static TUint16 tensorOf(NdArray<Short> src) {
        return Tensor.of(TUint16.class, src.shape(), src::copyTo);
    }

    public static TUint16 tensorOf(Shape shape) {
        return Tensor.of(TUint16.class, shape);
    }

    public static TUint16 tensorOf(Shape shape, ShortDataBuffer data) {
        return Tensor.of(TUint16.class, shape, (T d) -> d.copyFrom(data));
    }

    public static TUint16 tensorOf(Shape shape, Consumer<TUint16> dataInit) {
        return Tensor.of(TUint16.class, shape, dataInit);
    }

    public static TUint16 sparseTensorOf(TInt64 indices, TUint16 values, TInt64 denseShape) {
        return SparseTensor.of(indices, values, denseShape).asTypedTensor();
    }
}

