/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaSplitND", inputsClass=Inputs.class)
public final class SplitND<T extends TType>
extends RawOp
implements Iterable<Operand<T>> {
    public static final String OP_NAME = "XlaSplitND";
    private List<Output<T>> outputs;

    public SplitND(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outputsLength = operation.outputListLength("outputs");
        this.outputs = Arrays.asList(operation.outputList(outputIdx, outputsLength));
        outputIdx += outputsLength;
    }

    public static <T extends TType> SplitND<T> create(Scope scope, Operand<T> input, Long N, List<Long> numSplits, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "SplitND");
        opBuilder.addInput(input.asOutput());
        opBuilder.setAttr("N", N);
        long[] numSplitsArray = new long[numSplits.size()];
        for (int i = 0; i < numSplitsArray.length; ++i) {
            numSplitsArray[i] = numSplits.get(i);
        }
        opBuilder.setAttr("num_splits", numSplitsArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.paddings == null) continue;
                long[] paddingsArray = new long[opts.paddings.size()];
                for (int i = 0; i < paddingsArray.length; ++i) {
                    paddingsArray[i] = opts.paddings.get(i);
                }
                opBuilder.setAttr("paddings", paddingsArray);
            }
        }
        return new SplitND<T>(opBuilder.build());
    }

    public static Options paddings(List<Long> paddings) {
        return new Options().paddings(paddings);
    }

    public static Options paddings(Long ... paddings) {
        return new Options().paddings(paddings);
    }

    public List<Output<T>> outputs() {
        return this.outputs;
    }

    @Override
    public Iterator<Operand<T>> iterator() {
        return this.outputs.iterator();
    }

    @OpInputsMetadata(outputsClass=SplitND.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<SplitND<T>> {
        public final Operand<T> input;
        public final DataType T;
        public final long[] numSplits;
        public final long[] paddings;

        public Inputs(GraphOperation op) {
            super(new SplitND(op), op, Arrays.asList("T", "num_splits", "paddings"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.numSplits = op.attributes().getAttrIntList("num_splits");
            this.paddings = op.attributes().getAttrIntList("paddings");
        }
    }

    public static class Options {
        private List<Long> paddings;

        private Options() {
        }

        public Options paddings(List<Long> paddings) {
            this.paddings = paddings;
            return this;
        }

        public Options paddings(Long ... paddings) {
            this.paddings = Arrays.asList(paddings);
            return this;
        }
    }
}

