/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SplitDedupData", inputsClass=Inputs.class)
public final class SplitDedupData<T extends TNumber, U extends TNumber>
extends RawOp {
    public static final String OP_NAME = "SplitDedupData";
    private Output<T> integerTensor;
    private Output<U> floatTensor;

    public SplitDedupData(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.integerTensor = operation.output(outputIdx++);
        this.floatTensor = operation.output(outputIdx++);
    }

    public static <T extends TNumber, U extends TNumber> SplitDedupData<T, U> create(Scope scope, Operand<? extends TType> input, Class<T> integerType, Class<U> floatType, String tupleMask, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.setAttr("integer_type", Operands.toDataType(integerType));
        opBuilder.setAttr("float_type", Operands.toDataType(floatType));
        opBuilder.setAttr("tuple_mask", tupleMask);
        if (options != null) {
            for (Options opts : options) {
                if (opts.config == null) continue;
                opBuilder.setAttr("config", opts.config);
            }
        }
        return new SplitDedupData<T, U>(opBuilder.build());
    }

    public static Options config(String config) {
        return new Options().config(config);
    }

    public Output<T> integerTensor() {
        return this.integerTensor;
    }

    public Output<U> floatTensor() {
        return this.floatTensor;
    }

    @OpInputsMetadata(outputsClass=SplitDedupData.class)
    public static class Inputs
    extends RawOpInputs<SplitDedupData<?, ?>> {
        public final Operand<? extends TType> input;
        public final DataType integerType;
        public final DataType floatType;
        public final String tupleMask;
        public final String config;

        public Inputs(GraphOperation op) {
            super(new SplitDedupData(op), op, Arrays.asList("integer_type", "float_type", "tuple_mask", "config"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.integerType = op.attributes().getAttrType("integer_type");
            this.floatType = op.attributes().getAttrType("float_type");
            this.tupleMask = op.attributes().getAttrString("tuple_mask");
            this.config = op.attributes().getAttrString("config");
        }
    }

    public static class Options {
        private String config;

        private Options() {
        }

        public Options config(String config) {
            this.config = config;
            return this;
        }
    }
}

