/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;

@OpMetadata(opType="ConvertToCooTensor", inputsClass=Inputs.class)
public final class ConvertToCooTensor
extends RawOp {
    public static final String OP_NAME = "ConvertToCooTensor";
    private Output<TInt32> rowIds;
    private Output<TInt32> colIds;
    private Output<TFloat32> gains;

    public ConvertToCooTensor(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.rowIds = operation.output(outputIdx++);
        this.colIds = operation.output(outputIdx++);
        this.gains = operation.output(outputIdx++);
    }

    public static ConvertToCooTensor create(Scope scope, Operand<TInt32> indicesOrRowSplits, Operand<TInt32> values, Operand<TFloat32> weights, Long sampleCount, String combiner) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(indicesOrRowSplits.asOutput());
        opBuilder.addInput(values.asOutput());
        opBuilder.addInput(weights.asOutput());
        opBuilder.setAttr("sample_count", sampleCount);
        opBuilder.setAttr("combiner", combiner);
        return new ConvertToCooTensor(opBuilder.build());
    }

    public Output<TInt32> rowIds() {
        return this.rowIds;
    }

    public Output<TInt32> colIds() {
        return this.colIds;
    }

    public Output<TFloat32> gains() {
        return this.gains;
    }

    @OpInputsMetadata(outputsClass=ConvertToCooTensor.class)
    public static class Inputs
    extends RawOpInputs<ConvertToCooTensor> {
        public final Operand<TInt32> indicesOrRowSplits;
        public final Operand<TInt32> values;
        public final Operand<TFloat32> weights;
        public final long sampleCount;
        public final String combiner;

        public Inputs(GraphOperation op) {
            super(new ConvertToCooTensor(op), op, Arrays.asList("sample_count", "combiner"));
            int inputIndex = 0;
            this.indicesOrRowSplits = op.input(inputIndex++);
            this.values = op.input(inputIndex++);
            this.weights = op.input(inputIndex++);
            this.sampleCount = op.attributes().getAttrInt("sample_count");
            this.combiner = op.attributes().getAttrString("combiner");
        }
    }
}

