/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="DenseToDenseSetOperation", inputsClass=Inputs.class)
public final class DenseToDenseSetOperation<T extends TType>
extends RawOp {
    public static final String OP_NAME = "DenseToDenseSetOperation";
    private Output<TInt64> resultIndices;
    private Output<T> resultValues;
    private Output<TInt64> resultShape;

    public DenseToDenseSetOperation(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.resultIndices = operation.output(outputIdx++);
        this.resultValues = operation.output(outputIdx++);
        this.resultShape = operation.output(outputIdx++);
    }

    public static <T extends TType> DenseToDenseSetOperation<T> create(Scope scope, Operand<T> set1, Operand<T> set2, String setOperation, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(set1.asOutput());
        opBuilder.addInput(set2.asOutput());
        opBuilder.setAttr("set_operation", setOperation);
        if (options != null) {
            for (Options opts : options) {
                if (opts.validateIndices == null) continue;
                opBuilder.setAttr("validate_indices", opts.validateIndices);
            }
        }
        return new DenseToDenseSetOperation<T>(opBuilder.build());
    }

    public static Options validateIndices(Boolean validateIndices) {
        return new Options().validateIndices(validateIndices);
    }

    public Output<TInt64> resultIndices() {
        return this.resultIndices;
    }

    public Output<T> resultValues() {
        return this.resultValues;
    }

    public Output<TInt64> resultShape() {
        return this.resultShape;
    }

    @OpInputsMetadata(outputsClass=DenseToDenseSetOperation.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<DenseToDenseSetOperation<T>> {
        public final Operand<T> set1;
        public final Operand<T> set2;
        public final String setOperation;
        public final boolean validateIndices;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new DenseToDenseSetOperation(op), op, Arrays.asList("set_operation", "validate_indices", "T"));
            int inputIndex = 0;
            this.set1 = op.input(inputIndex++);
            this.set2 = op.input(inputIndex++);
            this.setOperation = op.attributes().getAttrString("set_operation");
            this.validateIndices = op.attributes().getAttrBool("validate_indices");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private Boolean validateIndices;

        private Options() {
        }

        public Options validateIndices(Boolean validateIndices) {
            this.validateIndices = validateIndices;
            return this;
        }
    }
}

