/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="MaxPoolGradGradV2", inputsClass=Inputs.class)
public final class MaxPoolGradGrad<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "MaxPoolGradGradV2";
    private Output<T> output;

    public MaxPoolGradGrad(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TNumber> MaxPoolGradGrad<T> create(Scope scope, Operand<T> origInput, Operand<T> origOutput, Operand<T> grad, Operand<TInt32> ksize, Operand<TInt32> strides, String padding, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "MaxPoolGradGrad");
        opBuilder.addInput(origInput.asOutput());
        opBuilder.addInput(origOutput.asOutput());
        opBuilder.addInput(grad.asOutput());
        opBuilder.addInput(ksize.asOutput());
        opBuilder.addInput(strides.asOutput());
        opBuilder.setAttr("padding", padding);
        if (options != null) {
            for (Options opts : options) {
                if (opts.dataFormat == null) continue;
                opBuilder.setAttr("data_format", opts.dataFormat);
            }
        }
        return new MaxPoolGradGrad<T>(opBuilder.build());
    }

    public static Options dataFormat(String dataFormat) {
        return new Options().dataFormat(dataFormat);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=MaxPoolGradGrad.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<MaxPoolGradGrad<T>> {
        public final Operand<T> origInput;
        public final Operand<T> origOutput;
        public final Operand<T> grad;
        public final Operand<TInt32> ksize;
        public final Operand<TInt32> strides;
        public final String padding;
        public final String dataFormat;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new MaxPoolGradGrad(op), op, Arrays.asList("padding", "data_format", "T"));
            int inputIndex = 0;
            this.origInput = op.input(inputIndex++);
            this.origOutput = op.input(inputIndex++);
            this.grad = op.input(inputIndex++);
            this.ksize = op.input(inputIndex++);
            this.strides = op.input(inputIndex++);
            this.padding = op.attributes().getAttrString("padding");
            this.dataFormat = op.attributes().getAttrString("data_format");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private String dataFormat;

        private Options() {
        }

        public Options dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }
    }
}

