/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="DataFormatVecPermute", inputsClass=Inputs.class)
public final class DataFormatVecPermute<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "DataFormatVecPermute";
    private Output<T> y;

    public DataFormatVecPermute(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.y = operation.output(outputIdx++);
    }

    public static <T extends TNumber> DataFormatVecPermute<T> create(Scope scope, Operand<T> x, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(x.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.srcFormat != null) {
                    opBuilder.setAttr("src_format", opts.srcFormat);
                }
                if (opts.dstFormat == null) continue;
                opBuilder.setAttr("dst_format", opts.dstFormat);
            }
        }
        return new DataFormatVecPermute<T>(opBuilder.build());
    }

    public static Options srcFormat(String srcFormat) {
        return new Options().srcFormat(srcFormat);
    }

    public static Options dstFormat(String dstFormat) {
        return new Options().dstFormat(dstFormat);
    }

    public Output<T> y() {
        return this.y;
    }

    @Override
    public Output<T> asOutput() {
        return this.y;
    }

    @OpInputsMetadata(outputsClass=DataFormatVecPermute.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<DataFormatVecPermute<T>> {
        public final Operand<T> x;
        public final DataType T;
        public final String srcFormat;
        public final String dstFormat;

        public Inputs(GraphOperation op) {
            super(new DataFormatVecPermute(op), op, Arrays.asList("T", "src_format", "dst_format"));
            int inputIndex = 0;
            this.x = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.srcFormat = op.attributes().getAttrString("src_format");
            this.dstFormat = op.attributes().getAttrString("dst_format");
        }
    }

    public static class Options {
        private String srcFormat;
        private String dstFormat;

        private Options() {
        }

        public Options srcFormat(String srcFormat) {
            this.srcFormat = srcFormat;
            return this;
        }

        public Options dstFormat(String dstFormat) {
            this.dstFormat = dstFormat;
            return this;
        }
    }
}

