/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="CTCGreedyDecoder", inputsClass=Inputs.class)
public final class CtcGreedyDecoder<T extends TNumber>
extends RawOp {
    public static final String OP_NAME = "CTCGreedyDecoder";
    private Output<TInt64> decodedIndices;
    private Output<TInt64> decodedValues;
    private Output<TInt64> decodedShape;
    private Output<T> logProbability;

    public CtcGreedyDecoder(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.decodedIndices = operation.output(outputIdx++);
        this.decodedValues = operation.output(outputIdx++);
        this.decodedShape = operation.output(outputIdx++);
        this.logProbability = operation.output(outputIdx++);
    }

    public static <T extends TNumber> CtcGreedyDecoder<T> create(Scope scope, Operand<T> inputs, Operand<TInt32> sequenceLength, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "CtcGreedyDecoder");
        opBuilder.addInput(inputs.asOutput());
        opBuilder.addInput(sequenceLength.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.mergeRepeated != null) {
                    opBuilder.setAttr("merge_repeated", opts.mergeRepeated);
                }
                if (opts.blankIndex == null) continue;
                opBuilder.setAttr("blank_index", opts.blankIndex);
            }
        }
        return new CtcGreedyDecoder<T>(opBuilder.build());
    }

    public static Options mergeRepeated(Boolean mergeRepeated) {
        return new Options().mergeRepeated(mergeRepeated);
    }

    public static Options blankIndex(Long blankIndex) {
        return new Options().blankIndex(blankIndex);
    }

    public Output<TInt64> decodedIndices() {
        return this.decodedIndices;
    }

    public Output<TInt64> decodedValues() {
        return this.decodedValues;
    }

    public Output<TInt64> decodedShape() {
        return this.decodedShape;
    }

    public Output<T> logProbability() {
        return this.logProbability;
    }

    @OpInputsMetadata(outputsClass=CtcGreedyDecoder.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<CtcGreedyDecoder<T>> {
        public final Operand<T> inputs;
        public final Operand<TInt32> sequenceLength;
        public final boolean mergeRepeated;
        public final long blankIndex;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new CtcGreedyDecoder(op), op, Arrays.asList("merge_repeated", "blank_index", "T"));
            int inputIndex = 0;
            this.inputs = op.input(inputIndex++);
            this.sequenceLength = op.input(inputIndex++);
            this.mergeRepeated = op.attributes().getAttrBool("merge_repeated");
            this.blankIndex = op.attributes().getAttrInt("blank_index");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private Boolean mergeRepeated;
        private Long blankIndex;

        private Options() {
        }

        public Options mergeRepeated(Boolean mergeRepeated) {
            this.mergeRepeated = mergeRepeated;
            return this;
        }

        public Options blankIndex(Long blankIndex) {
            this.blankIndex = blankIndex;
            return this;
        }
    }
}

