/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TridiagonalSolve", inputsClass=Inputs.class)
public final class TridiagonalSolve<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "TridiagonalSolve";
    private Output<T> output;

    public TridiagonalSolve(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> TridiagonalSolve<T> create(Scope scope, Operand<T> diagonals, Operand<T> rhs, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(diagonals.asOutput());
        opBuilder.addInput(rhs.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.partialPivoting != null) {
                    opBuilder.setAttr("partial_pivoting", opts.partialPivoting);
                }
                if (opts.perturbSingular == null) continue;
                opBuilder.setAttr("perturb_singular", opts.perturbSingular);
            }
        }
        return new TridiagonalSolve<T>(opBuilder.build());
    }

    public static Options partialPivoting(Boolean partialPivoting) {
        return new Options().partialPivoting(partialPivoting);
    }

    public static Options perturbSingular(Boolean perturbSingular) {
        return new Options().perturbSingular(perturbSingular);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=TridiagonalSolve.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<TridiagonalSolve<T>> {
        public final Operand<T> diagonals;
        public final Operand<T> rhs;
        public final boolean partialPivoting;
        public final boolean perturbSingular;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new TridiagonalSolve(op), op, Arrays.asList("partial_pivoting", "perturb_singular", "T"));
            int inputIndex = 0;
            this.diagonals = op.input(inputIndex++);
            this.rhs = op.input(inputIndex++);
            this.partialPivoting = op.attributes().getAttrBool("partial_pivoting");
            this.perturbSingular = op.attributes().getAttrBool("perturb_singular");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private Boolean partialPivoting;
        private Boolean perturbSingular;

        private Options() {
        }

        public Options partialPivoting(Boolean partialPivoting) {
            this.partialPivoting = partialPivoting;
            return this;
        }

        public Options perturbSingular(Boolean perturbSingular) {
            this.perturbSingular = perturbSingular;
            return this;
        }
    }
}

