/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="BatchMatrixTriangularSolve", inputsClass=Inputs.class)
public final class BatchMatrixTriangularSolve<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "BatchMatrixTriangularSolve";
    private Output<T> output;

    public BatchMatrixTriangularSolve(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TNumber> BatchMatrixTriangularSolve<T> create(Scope scope, Operand<T> matrix, Operand<T> rhs, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(matrix.asOutput());
        opBuilder.addInput(rhs.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.lower != null) {
                    opBuilder.setAttr("lower", opts.lower);
                }
                if (opts.adjoint == null) continue;
                opBuilder.setAttr("adjoint", opts.adjoint);
            }
        }
        return new BatchMatrixTriangularSolve<T>(opBuilder.build());
    }

    public static Options lower(Boolean lower) {
        return new Options().lower(lower);
    }

    public static Options adjoint(Boolean adjoint) {
        return new Options().adjoint(adjoint);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=BatchMatrixTriangularSolve.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<BatchMatrixTriangularSolve<T>> {
        public final Operand<T> matrix;
        public final Operand<T> rhs;
        public final boolean lower;
        public final boolean adjoint;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new BatchMatrixTriangularSolve(op), op, Arrays.asList("lower", "adjoint", "T"));
            int inputIndex = 0;
            this.matrix = op.input(inputIndex++);
            this.rhs = op.input(inputIndex++);
            this.lower = op.attributes().getAttrBool("lower");
            this.adjoint = op.attributes().getAttrBool("adjoint");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private Boolean lower;
        private Boolean adjoint;

        private Options() {
        }

        public Options lower(Boolean lower) {
            this.lower = lower;
            return this;
        }

        public Options adjoint(Boolean adjoint) {
            this.adjoint = adjoint;
            return this;
        }
    }
}

