/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TString;

@OpMetadata(opType="LMDBReader", inputsClass=Inputs.class)
public final class LmdbReader
extends RawOp
implements Operand<TString> {
    public static final String OP_NAME = "LMDBReader";
    private Output<TString> readerHandle;

    public LmdbReader(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.readerHandle = operation.output(outputIdx++);
    }

    public static LmdbReader create(Scope scope, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "LmdbReader");
        if (options != null) {
            for (Options opts : options) {
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName == null) continue;
                opBuilder.setAttr("shared_name", opts.sharedName);
            }
        }
        return new LmdbReader(opBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public Output<TString> readerHandle() {
        return this.readerHandle;
    }

    @Override
    public Output<TString> asOutput() {
        return this.readerHandle;
    }

    @OpInputsMetadata(outputsClass=LmdbReader.class)
    public static class Inputs
    extends RawOpInputs<LmdbReader> {
        public final String container;
        public final String sharedName;

        public Inputs(GraphOperation op) {
            super(new LmdbReader(op), op, Arrays.asList("container", "shared_name"));
            boolean inputIndex = false;
            this.container = op.attributes().getAttrString("container");
            this.sharedName = op.attributes().getAttrString("shared_name");
        }
    }

    public static class Options {
        private String container;
        private String sharedName;

        private Options() {
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }
    }
}

