/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data.experimental;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ExperimentalRebatchDataset", inputsClass=Inputs.class)
public final class RebatchDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "ExperimentalRebatchDataset";
    private Output<? extends TType> handle;

    public RebatchDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static RebatchDataset create(Scope scope, Operand<? extends TType> inputDataset, Operand<TInt64> numReplicas, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "RebatchDataset");
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(numReplicas.asOutput());
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.useFallback == null) continue;
                opBuilder.setAttr("use_fallback", opts.useFallback);
            }
        }
        return new RebatchDataset(opBuilder.build());
    }

    public static Options useFallback(Boolean useFallback) {
        return new Options().useFallback(useFallback);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=RebatchDataset.class)
    public static class Inputs
    extends RawOpInputs<RebatchDataset> {
        public final Operand<? extends TType> inputDataset;
        public final Operand<TInt64> numReplicas;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;
        public final boolean useFallback;

        public Inputs(GraphOperation op) {
            super(new RebatchDataset(op), op, Arrays.asList("output_types", "output_shapes", "use_fallback"));
            int inputIndex = 0;
            this.inputDataset = op.input(inputIndex++);
            this.numReplicas = op.input(inputIndex++);
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
            this.useFallback = op.attributes().getAttrBool("use_fallback");
        }
    }

    public static class Options {
        private Boolean useFallback;

        private Options() {
        }

        public Options useFallback(Boolean useFallback) {
            this.useFallback = useFallback;
            return this;
        }
    }
}

