/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SerializeIterator", inputsClass=Inputs.class)
public final class SerializeIterator
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "SerializeIterator";
    private Output<? extends TType> serialized;

    public SerializeIterator(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.serialized = operation.output(outputIdx++);
    }

    public static SerializeIterator create(Scope scope, Operand<? extends TType> resourceHandle, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(resourceHandle.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.externalStatePolicy == null) continue;
                opBuilder.setAttr("external_state_policy", opts.externalStatePolicy);
            }
        }
        return new SerializeIterator(opBuilder.build());
    }

    public static Options externalStatePolicy(Long externalStatePolicy) {
        return new Options().externalStatePolicy(externalStatePolicy);
    }

    public Output<? extends TType> serialized() {
        return this.serialized;
    }

    @Override
    public Output<TType> asOutput() {
        return this.serialized;
    }

    @OpInputsMetadata(outputsClass=SerializeIterator.class)
    public static class Inputs
    extends RawOpInputs<SerializeIterator> {
        public final Operand<? extends TType> resourceHandle;
        public final long externalStatePolicy;

        public Inputs(GraphOperation op) {
            super(new SerializeIterator(op), op, Arrays.asList("external_state_policy"));
            int inputIndex = 0;
            this.resourceHandle = op.input(inputIndex++);
            this.externalStatePolicy = op.attributes().getAttrInt("external_state_policy");
        }
    }

    public static class Options {
        private Long externalStatePolicy;

        private Options() {
        }

        public Options externalStatePolicy(Long externalStatePolicy) {
            this.externalStatePolicy = externalStatePolicy;
            return this;
        }
    }
}

