/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="DatasetCardinality", inputsClass=Inputs.class)
public final class DatasetCardinality
extends RawOp
implements Operand<TInt64> {
    public static final String OP_NAME = "DatasetCardinality";
    private Output<TInt64> cardinality;

    public DatasetCardinality(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.cardinality = operation.output(outputIdx++);
    }

    public static DatasetCardinality create(Scope scope, Operand<? extends TType> inputDataset, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputDataset.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.cardinalityOptions == null) continue;
                opBuilder.setAttr("cardinality_options", opts.cardinalityOptions);
            }
        }
        return new DatasetCardinality(opBuilder.build());
    }

    public static Options cardinalityOptions(String cardinalityOptions) {
        return new Options().cardinalityOptions(cardinalityOptions);
    }

    public Output<TInt64> cardinality() {
        return this.cardinality;
    }

    @Override
    public Output<TInt64> asOutput() {
        return this.cardinality;
    }

    @OpInputsMetadata(outputsClass=DatasetCardinality.class)
    public static class Inputs
    extends RawOpInputs<DatasetCardinality> {
        public final Operand<? extends TType> inputDataset;
        public final String cardinalityOptions;

        public Inputs(GraphOperation op) {
            super(new DatasetCardinality(op), op, Arrays.asList("cardinality_options"));
            int inputIndex = 0;
            this.inputDataset = op.input(inputIndex++);
            this.cardinalityOptions = op.attributes().getAttrString("cardinality_options");
        }
    }

    public static class Options {
        private String cardinalityOptions;

        private Options() {
        }

        public Options cardinalityOptions(String cardinalityOptions) {
            this.cardinalityOptions = cardinalityOptions;
            return this;
        }
    }
}

