/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TensorMapStackKeys", inputsClass=Inputs.class)
public final class TensorMapStackKeys<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "TensorMapStackKeys";
    private Output<T> keys;

    public TensorMapStackKeys(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.keys = operation.output(outputIdx++);
    }

    public static <T extends TType> TensorMapStackKeys<T> create(Scope scope, Operand<? extends TType> inputHandle, Class<T> keyDtype) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputHandle.asOutput());
        opBuilder.setAttr("key_dtype", Operands.toDataType(keyDtype));
        return new TensorMapStackKeys<T>(opBuilder.build());
    }

    public Output<T> keys() {
        return this.keys;
    }

    @Override
    public Output<T> asOutput() {
        return this.keys;
    }

    @OpInputsMetadata(outputsClass=TensorMapStackKeys.class)
    public static class Inputs
    extends RawOpInputs<TensorMapStackKeys<?>> {
        public final Operand<? extends TType> inputHandle;
        public final DataType keyDtype;

        public Inputs(GraphOperation op) {
            super(new TensorMapStackKeys(op), op, Arrays.asList("key_dtype"));
            int inputIndex = 0;
            this.inputHandle = op.input(inputIndex++);
            this.keyDtype = op.attributes().getAttrType("key_dtype");
        }
    }
}

