/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TensorMapErase", inputsClass=Inputs.class)
public final class TensorMapErase
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "TensorMapErase";
    private Output<? extends TType> outputHandle;

    public TensorMapErase(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.outputHandle = operation.output(outputIdx++);
    }

    public static <U extends TType> TensorMapErase create(Scope scope, Operand<? extends TType> inputHandle, Operand<? extends TType> key, Class<U> valueDtype) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputHandle.asOutput());
        opBuilder.addInput(key.asOutput());
        opBuilder.setAttr("value_dtype", Operands.toDataType(valueDtype));
        return new TensorMapErase(opBuilder.build());
    }

    public Output<? extends TType> outputHandle() {
        return this.outputHandle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.outputHandle;
    }

    @OpInputsMetadata(outputsClass=TensorMapErase.class)
    public static class Inputs
    extends RawOpInputs<TensorMapErase> {
        public final Operand<? extends TType> inputHandle;
        public final Operand<? extends TType> key;
        public final DataType keyDtype;
        public final DataType valueDtype;

        public Inputs(GraphOperation op) {
            super(new TensorMapErase(op), op, Arrays.asList("key_dtype", "value_dtype"));
            int inputIndex = 0;
            this.inputHandle = op.input(inputIndex++);
            this.key = op.input(inputIndex++);
            this.keyDtype = op.attributes().getAttrType("key_dtype");
            this.valueDtype = op.attributes().getAttrType("value_dtype");
        }
    }
}

