/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="StackPopV2", inputsClass=Inputs.class)
public final class StackPop<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "StackPopV2";
    private Output<T> elem;

    public StackPop(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.elem = operation.output(outputIdx++);
    }

    public static <T extends TType> StackPop<T> create(Scope scope, Operand<? extends TType> handle, Class<T> elemType) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "StackPop");
        opBuilder.addInput(handle.asOutput());
        opBuilder.setAttr("elem_type", Operands.toDataType(elemType));
        return new StackPop<T>(opBuilder.build());
    }

    public Output<T> elem() {
        return this.elem;
    }

    @Override
    public Output<T> asOutput() {
        return this.elem;
    }

    @OpInputsMetadata(outputsClass=StackPop.class)
    public static class Inputs
    extends RawOpInputs<StackPop<?>> {
        public final Operand<? extends TType> handle;
        public final DataType elemType;

        public Inputs(GraphOperation op) {
            super(new StackPop(op), op, Arrays.asList("elem_type"));
            int inputIndex = 0;
            this.handle = op.input(inputIndex++);
            this.elemType = op.attributes().getAttrType("elem_type");
        }
    }
}

