/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="RandomIndexShuffle", inputsClass=Inputs.class)
public final class RandomIndexShuffle<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "RandomIndexShuffle";
    private Output<T> output;

    public RandomIndexShuffle(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TNumber> RandomIndexShuffle<T> create(Scope scope, Operand<T> index, Operand<? extends TNumber> seed, Operand<T> maxIndex, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(index.asOutput());
        opBuilder.addInput(seed.asOutput());
        opBuilder.addInput(maxIndex.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.rounds == null) continue;
                opBuilder.setAttr("rounds", opts.rounds);
            }
        }
        return new RandomIndexShuffle<T>(opBuilder.build());
    }

    public static Options rounds(Long rounds) {
        return new Options().rounds(rounds);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=RandomIndexShuffle.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<RandomIndexShuffle<T>> {
        public final Operand<T> index;
        public final Operand<? extends TNumber> seed;
        public final Operand<T> maxIndex;
        public final long rounds;
        public final DataType dtype;
        public final DataType Tseed;

        public Inputs(GraphOperation op) {
            super(new RandomIndexShuffle(op), op, Arrays.asList("rounds", "dtype", "Tseed"));
            int inputIndex = 0;
            this.index = op.input(inputIndex++);
            this.seed = op.input(inputIndex++);
            this.maxIndex = op.input(inputIndex++);
            this.rounds = op.attributes().getAttrInt("rounds");
            this.dtype = op.attributes().getAttrType("dtype");
            this.Tseed = op.attributes().getAttrType("Tseed");
        }
    }

    public static class Options {
        private Long rounds;

        private Options() {
        }

        public Options rounds(Long rounds) {
            this.rounds = rounds;
            return this;
        }
    }
}

