/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.Operand;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Scope;
import org.tensorflow.op.core.StatefulIf;
import org.tensorflow.op.core.StatelessIf;
import org.tensorflow.types.family.TType;

public interface If
extends Iterable<Operand<TType>> {
    public static If create(Scope scope, Operand<? extends TType> cond, Iterable<Operand<?>> input, List<Class<? extends TType>> Tout, ConcreteFunction thenBranch, ConcreteFunction elseBranch, Options ... options) {
        boolean isStateful = false;
        if (thenBranch.isStateful()) {
            isStateful = true;
        }
        if (elseBranch.isStateful()) {
            isStateful = true;
        }
        if (isStateful) {
            return StatefulIf.create(scope, cond, input, Tout, thenBranch, elseBranch, options);
        }
        return StatelessIf.create(scope, cond, input, Tout, thenBranch, elseBranch, options);
    }

    public static Options outputShapes(List<Shape> outputShapes) {
        return new Options().outputShapes(outputShapes);
    }

    public static Options outputShapes(Shape ... outputShapes) {
        return new Options().outputShapes(outputShapes);
    }

    public List<Output<?>> output();

    @Override
    public Iterator<Operand<TType>> iterator();

    public static class Options {
        List<Shape> outputShapes;

        private Options() {
        }

        public Options outputShapes(List<Shape> outputShapes) {
            this.outputShapes = outputShapes;
            return this;
        }

        public Options outputShapes(Shape ... outputShapes) {
            this.outputShapes = Arrays.asList(outputShapes);
            return this;
        }
    }
}

