/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="CompositeTensorVariantToComponents", inputsClass=Inputs.class)
public final class CompositeTensorVariantToComponents
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "CompositeTensorVariantToComponents";
    private List<Output<?>> components;

    public CompositeTensorVariantToComponents(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int componentsLength = operation.outputListLength("components");
        this.components = Arrays.asList(operation.outputList(outputIdx, componentsLength));
        outputIdx += componentsLength;
    }

    public static CompositeTensorVariantToComponents create(Scope scope, Operand<? extends TType> encoded, String metadata, List<Class<? extends TType>> Tcomponents) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(encoded.asOutput());
        opBuilder.setAttr("metadata", metadata);
        opBuilder.setAttr("Tcomponents", Operands.toDataTypes(Tcomponents));
        return new CompositeTensorVariantToComponents(opBuilder.build());
    }

    public List<Output<?>> components() {
        return this.components;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.components.iterator();
    }

    @OpInputsMetadata(outputsClass=CompositeTensorVariantToComponents.class)
    public static class Inputs
    extends RawOpInputs<CompositeTensorVariantToComponents> {
        public final Operand<? extends TType> encoded;
        public final String metadata;
        public final DataType[] Tcomponents;

        public Inputs(GraphOperation op) {
            super(new CompositeTensorVariantToComponents(op), op, Arrays.asList("metadata", "Tcomponents"));
            int inputIndex = 0;
            this.encoded = op.input(inputIndex++);
            this.metadata = op.attributes().getAttrString("metadata");
            this.Tcomponents = op.attributes().getAttrTypeList("Tcomponents");
        }
    }
}

